/*
 * Decompiled with CFR 0.152.
 */
package com.cenqua.fisheye.lucene;

import com.cenqua.fisheye.logging.Logs;
import com.cenqua.fisheye.lucene.LongField;
import com.cenqua.fisheye.lucene.TermDocVistor;
import com.cenqua.fisheye.lucene.TermVisitor;
import com.cenqua.fisheye.rep.DbException;
import java.io.IOException;
import java.io.Reader;
import java.util.ArrayList;
import java.util.BitSet;
import java.util.List;
import org.apache.lucene.document.Field;
import org.apache.lucene.index.IndexReader;
import org.apache.lucene.index.Term;
import org.apache.lucene.search.Filter;
import org.apache.lucene.search.HitCollector;
import org.apache.lucene.search.IndexSearcher;
import org.apache.lucene.search.Query;

public class LuceneHelper {
    public static List findTerms(IndexReader reader, String field) throws DbException {
        final ArrayList terms = new ArrayList();
        TermVisitor.visitTermDocs(reader, field, new TermVisitor.Visitor(){

            public boolean visit(Term t) {
                terms.add(t.text());
                return true;
            }
        });
        return terms;
    }

    public static boolean existsMatchingDocuments(IndexSearcher searcher, Query q, Filter f2) throws IOException {
        return LuceneHelper.countMatchingDocuments(searcher, q, f2) > 0;
    }

    public static int countMatchingDocuments(IndexSearcher searcher, Query q, Filter f2) throws IOException {
        class MyCollector
        extends HitCollector {
            int result = 0;

            MyCollector() {
            }

            public void collect(int doc, float score) {
                ++this.result;
            }
        }
        MyCollector c2 = new MyCollector();
        searcher.search(q, f2, (HitCollector)c2);
        return c2.result;
    }

    public static BitSet collectMatchingDocuments(IndexSearcher searcher, Query q, Filter f2) throws IOException {
        BitSet bits = new BitSet(searcher.maxDoc());
        LuceneHelper.collectMatchingDocuments(searcher, q, f2, bits);
        return bits;
    }

    public static void collectMatchingDocuments(IndexSearcher searcher, Query q, Filter f2, final BitSet bits) throws IOException {
        searcher.search(q, f2, new HitCollector(){

            public void collect(int doc, float score) {
                bits.set(doc);
            }
        });
    }

    public static Field Indexed(String name, String value) {
        return new Field(name, value, Field.Store.NO, Field.Index.UN_TOKENIZED);
    }

    public static Field Keyword(String name, String value) {
        return new Field(name, value, Field.Store.YES, Field.Index.UN_TOKENIZED);
    }

    public static Field UnStored(String name, String value) {
        return new Field(name, value, Field.Store.NO, Field.Index.TOKENIZED);
    }

    public static Field Text(String name, String value) {
        return new Field(name, value, Field.Store.YES, Field.Index.TOKENIZED);
    }

    public static Field Text(String name, Reader value) {
        return new Field(name, value, Field.TermVector.NO);
    }

    public static BitSet collectDocumentsWithTerm(IndexReader reader, String term) throws IOException {
        final BitSet bits = new BitSet(reader.maxDoc());
        try {
            Term startTerm = new Term(term, "");
            Term endTerm = null;
            TermDocVistor.visitTermDocs(reader, startTerm, endTerm, new TermDocVistor.Visitor(){

                public boolean visitTerm(Term t) {
                    return true;
                }

                public boolean visitDoc(int docId) {
                    bits.set(docId);
                    return true;
                }
            });
        }
        catch (DbException e2) {
            Logs.APP_LOG.error((Object)"unexpected ex", (Throwable)e2);
        }
        return bits;
    }

    public static String dateToReverseString(long date) {
        if (date == Long.MIN_VALUE) {
            return LongField.longToString(Long.MAX_VALUE);
        }
        return LongField.longToString(-date);
    }
}

