/*
 * Decompiled with CFR 0.152.
 */
package com.cenqua.fisheye.perforce;

import com.cenqua.fisheye.Path;
import com.cenqua.fisheye.rep.RepositoryInfo;

public class P4RepositoryInfo
extends RepositoryInfo {
    private String server;
    private int port;
    private String basePathSpec;
    private Path basePath;
    private String username;
    private String password;
    private boolean unicode;
    private boolean caseSensitive;
    private int maxFilelogs = -1;

    public void setServer(String server) {
        this.server = server;
    }

    public void setPort(int port) {
        this.port = port;
    }

    public void setBasePath(String p4PathSpec) {
        if (p4PathSpec == null || p4PathSpec.trim().length() == 0) {
            this.basePath = null;
        } else {
            this.basePathSpec = p4PathSpec.trim();
            if (this.basePathSpec.endsWith("...")) {
                this.basePathSpec = this.basePathSpec.substring(0, this.basePathSpec.length() - "...".length());
            }
            if (this.basePathSpec.endsWith("/")) {
                this.basePathSpec = this.basePathSpec.substring(0, this.basePathSpec.length() - 1);
            }
            this.basePath = new Path(this.basePathSpec.substring(1));
        }
    }

    public boolean isCaseSensitive() {
        return this.caseSensitive;
    }

    public void setCaseSensitive(boolean caseSensitive) {
        this.caseSensitive = caseSensitive;
    }

    public int getMaxFilelogs() {
        return this.maxFilelogs;
    }

    public void setMaxFilelogs(int maxFilelogs) {
        this.maxFilelogs = maxFilelogs;
    }

    public String getServer() {
        return this.server;
    }

    public int getPort() {
        return this.port;
    }

    public void setUsername(String username) {
        this.username = username;
    }

    public void setPassword(String password) {
        this.password = password;
    }

    public String getUsername() {
        return this.username;
    }

    public String getPassword() {
        return this.password;
    }

    public String getBasePath() {
        return this.basePathSpec;
    }

    public boolean isUnicode() {
        return this.unicode;
    }

    public void setUnicode(boolean unicode) {
        this.unicode = unicode;
    }

    public Path getLocalPath(String p4Path, long rev) {
        Path path = new Path(p4Path.substring(1));
        return path.getRelativePath(this.basePath, this.isCaseSensitive());
    }

    public String getRepositoryDescriptor() {
        return this.getServer() + ":" + this.getPort() + this.getBasePath();
    }

    public String getServerPath(Path localPath, long rev) {
        String path = localPath.isRoot() ? this.basePathSpec : this.basePathSpec + "/" + localPath.getPath();
        return path;
    }
}

