/*
 * Decompiled with CFR 0.152.
 */
package com.cenqua.fisheye.perforce.client;

import com.cenqua.fisheye.Path;
import com.cenqua.fisheye.io.IOHelper;
import com.cenqua.fisheye.logging.Logs;
import com.cenqua.fisheye.perforce.P4BranchMapping;
import com.cenqua.fisheye.perforce.P4BranchSpec;
import com.cenqua.fisheye.perforce.P4RepositoryInfo;
import com.cenqua.fisheye.perforce.client.AnnotateCallBack;
import com.cenqua.fisheye.perforce.client.DescribeProcessor;
import com.cenqua.fisheye.perforce.client.P4ChangeList;
import com.cenqua.fisheye.perforce.client.P4ChangePath;
import com.cenqua.fisheye.perforce.client.P4CliUtils;
import com.cenqua.fisheye.perforce.client.P4ClientException;
import com.cenqua.fisheye.perforce.client.P4Exec;
import com.cenqua.fisheye.perforce.client.P4FieldProcessor;
import com.cenqua.fisheye.perforce.client.P4FileSpec;
import com.cenqua.fisheye.perforce.client.P4Fix;
import com.cenqua.fisheye.perforce.client.P4Job;
import com.cenqua.fisheye.perforce.client.P4Label;
import com.cenqua.fisheye.perforce.client.P4OutputLineProcessor;
import com.cenqua.fisheye.perforce.client.P4OutputProcessor;
import com.cenqua.fisheye.perforce.client.P4Process;
import com.cenqua.fisheye.perforce.client.P4Visitor;
import com.cenqua.fisheye.perforce.client.P4ZTagProcessor;
import com.cenqua.fisheye.rep.RepositoryStatus;
import com.cenqua.fisheye.util.Throttle;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.SortedMap;
import java.util.TreeMap;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class P4Client {
    private P4RepositoryInfo repoInfo;
    private static final int DEFAULT_MAX_FILELOGS = 50000;
    private static final int DEFAULT_MAX_PRINT = 100;
    private static final int DEFAULT_MAX_PRINT_BYTES = 1000000;
    private P4Exec exec;
    private final int maxFilelogs;
    private final int maxPrint;
    private String separator = System.getProperty("line.separator");
    private int maxPrintBytes;
    private RepositoryStatus repoStatus;

    public P4Client(P4RepositoryInfo repoInfo, Throttle throttle) throws P4ClientException {
        this.exec = new P4Exec(repoInfo, throttle);
        this.repoInfo = repoInfo;
        this.exec.login();
        this.maxFilelogs = repoInfo.getMaxFilelogs() > 0 ? repoInfo.getMaxFilelogs() : 50000;
        this.maxPrint = 100;
        this.maxPrintBytes = 1000000;
    }

    public Map info() throws P4ClientException {
        final Map[] result = new Map[1];
        String exitStatus = this.exec.executeZTagCommand(P4CliUtils.tokenizeCommand("info"), null, new P4ZTagProcessor(){

            public void processGroup(Map group) {
                result[0] = group;
            }
        });
        if (exitStatus != null) {
            throw new P4ClientException("Unable to get repository info: " + exitStatus);
        }
        return result[0];
    }

    public int getMaxPrint() {
        return this.maxPrint;
    }

    public long getLatestRevision() throws P4ClientException {
        List<String> command = P4CliUtils.tokenizeCommand("changes -m 1 -s submitted");
        command.add(this.repoInfo.getBasePath() + '/' + "...");
        final Long[] result = new Long[1];
        String exitStatus = this.exec.executeZTagCommand(command, null, new P4ZTagProcessor(){

            public void processGroup(Map group) {
                result[0] = Long.valueOf((String)group.get("change"));
            }
        });
        if (exitStatus != null) {
            throw new P4ClientException("Unable to get repository latest revision: " + exitStatus);
        }
        if (result[0] == null) {
            return 0L;
        }
        return result[0];
    }

    public SortedMap<Long, P4ChangeList> getChangeLists(long startRevision, long blockSize, long latestRevision, final boolean fullInfo) throws P4ClientException {
        long endRevision;
        if (blockSize > 0L) {
            endRevision = startRevision + blockSize - 1L;
            if (endRevision > latestRevision) {
                endRevision = latestRevision;
            }
        } else {
            endRevision = latestRevision;
        }
        List<String> command = fullInfo ? P4CliUtils.tokenizeCommand("changes -l") : P4CliUtils.tokenizeCommand("changes");
        command.add(this.repoInfo.getBasePath() + '/' + "..." + "@" + startRevision + "," + endRevision);
        final TreeMap<Long, P4ChangeList> changeLists = new TreeMap<Long, P4ChangeList>();
        String status = this.exec.executeZTagCommand(command, "change", new P4ZTagProcessor(){

            public void processGroup(Map group) {
                long changeListId = Long.parseLong((String)group.get("change"));
                if (fullInfo) {
                    P4ChangeList changeList = new P4ChangeList(changeListId);
                    changeList.setUser((String)group.get("user"));
                    changeList.setClient((String)group.get("client"));
                    changeList.addComment((String)group.get("desc"));
                    changeList.setDate(1000L * Long.parseLong((String)group.get("time")));
                    Logs.APP_LOG.debug((Object)("[" + P4Client.this.repoInfo.getRepositoryDescriptor() + "] Adding changelist " + changeListId));
                    changeLists.put(changeListId, changeList);
                } else {
                    changeLists.put(changeListId, null);
                }
            }
        });
        if (status != null) {
            throw new P4ClientException(status);
        }
        if (fullInfo) {
            this.addChangesInformation(changeLists);
            this.addFileInfo(changeLists);
            this.addFixes(changeLists);
            this.removeBadPaths(changeLists);
        }
        return changeLists;
    }

    private void addFixes(final SortedMap<Long, P4ChangeList> changeLists) throws P4ClientException {
        if (changeLists.isEmpty()) {
            return;
        }
        if (this.repoStatus.isStopRequested()) {
            return;
        }
        Logs.APP_LOG.debug((Object)("[" + this.repoInfo.getRepositoryDescriptor() + "] Adding fix information"));
        Long firstChangeList = changeLists.firstKey();
        Long lastChangeList = changeLists.lastKey();
        List<String> command = P4CliUtils.tokenizeCommand("fixes");
        command.add(this.repoInfo.getBasePath() + '/' + "..." + "@" + firstChangeList + "," + lastChangeList);
        String status = this.exec.executeZTagCommand(command, "Job", new P4ZTagProcessor(){

            @Override
            public void processGroup(Map<String, String> group) {
                String jobName = group.get("Job");
                long changeId = Long.parseLong(group.get("Change"));
                long fixDate = Long.parseLong(group.get("Date"));
                String user = group.get("User");
                P4Fix fix = new P4Fix(jobName, changeId, fixDate, user);
                P4ChangeList change = (P4ChangeList)changeLists.get(changeId);
                change.addFix(fix);
            }
        });
        if (status != null) {
            throw new P4ClientException(status);
        }
    }

    public P4Job getJob(String jobName) throws P4ClientException {
        P4Job job;
        List<String> command = P4CliUtils.tokenizeCommand("job -o " + jobName);
        String status = this.exec.executeFieldCommand(command, false, new P4FieldProcessor(job = new P4Job()){
            final /* synthetic */ P4Job val$job;
            {
                this.val$job = p4Job;
            }

            public void processField(String fieldName, String fieldValue) {
                if (fieldName.equals("Job")) {
                    this.val$job.setName(fieldValue);
                } else if (fieldName.equals("Description")) {
                    this.val$job.setDescription(fieldValue);
                } else {
                    this.val$job.setField(fieldName, fieldValue);
                }
            }
        });
        if (status != null) {
            throw new P4ClientException(status);
        }
        return job;
    }

    private void removeBadPaths(SortedMap<Long, P4ChangeList> changeLists) {
        for (P4ChangeList changeList : changeLists.values()) {
            changeList.removeBadPaths();
        }
    }

    private void addFileInfo(SortedMap<Long, P4ChangeList> changeLists) throws P4ClientException {
        if (changeLists.isEmpty()) {
            return;
        }
        Logs.APP_LOG.debug((Object)("[" + this.repoInfo.getRepositoryDescriptor() + "] Adding file information"));
        int numPaths = 0;
        ArrayList<String> fileList = new ArrayList<String>();
        for (P4ChangeList changeList : changeLists.values()) {
            for (P4ChangePath changePath : changeList.getChangePaths()) {
                if (this.repoStatus.isStopRequested()) {
                    return;
                }
                fileList.add(changePath.getPath() + "#" + changePath.getFileRev());
                if (++numPaths <= this.maxFilelogs) continue;
                this.execFilelog(changeLists, fileList);
                fileList.clear();
                numPaths = 0;
            }
        }
        if (numPaths != 0) {
            this.execFilelog(changeLists, fileList);
        }
    }

    private void execFstat(final SortedMap<Long, P4ChangeList> changeLists, StringBuilder fstatFiles) throws P4ClientException {
        String status = this.exec.executeWithInput(P4CliUtils.tokenizeCommand("fstat -Ol"), fstatFiles.toString(), "depotFile", new P4ZTagProcessor(){

            @Override
            public void processGroup(Map<String, String> pathProps) throws P4ClientException {
                String path = pathProps.get("depotFile");
                long csid = Long.parseLong(pathProps.get("headChange"));
                P4ChangeList changeList = (P4ChangeList)changeLists.get(csid);
                if (changeList != null) {
                    P4ChangePath p4Path = changeList.getChangePath(path);
                    if (p4Path == null) {
                        int rev = Integer.parseInt(pathProps.get("headRev"));
                        P4FileSpec fileSpec = new P4FileSpec(path, rev);
                        if (P4Client.this.repoInfo.isPathInRepo(fileSpec.getPath(), csid)) {
                            p4Path = new P4ChangePath(fileSpec);
                            changeList.addChangePath(p4Path);
                        }
                    }
                    if (p4Path != null) {
                        if (!pathProps.containsKey("headType")) {
                            Logs.APP_LOG.warn((Object)("[" + P4Client.this.repoInfo.getRepositoryDescriptor() + "] Unable to determine file's type from fstat property map: " + pathProps));
                        }
                        p4Path.setFileType(pathProps.get("headType"));
                        p4Path.setAction(pathProps.get("headAction"));
                        if (pathProps.containsKey("fileSize")) {
                            p4Path.setFileSize(Long.parseLong(pathProps.get("fileSize")));
                        }
                    }
                }
            }
        });
        if (status != null) {
            throw new P4ClientException(status);
        }
    }

    private void execFilelog(SortedMap<Long, P4ChangeList> changeLists, List<String> fileList) throws P4ClientException {
        String status = this.fetchFileLog(changeLists, fileList);
        if (status != null) {
            int size = fileList.size();
            if (size > 1) {
                int midPoint = size / 2;
                this.execFilelog(changeLists, fileList.subList(0, midPoint));
                this.execFilelog(changeLists, fileList.subList(midPoint, size - 1));
            } else if (size == 1) {
                Logs.APP_LOG.warn((Object)("Unable to get file log for " + fileList.get(0)));
            }
        }
    }

    private String fetchFileLog(final SortedMap<Long, P4ChangeList> changeLists, List<String> fileList) throws P4ClientException {
        StringBuilder filelogArgs = new StringBuilder();
        filelogArgs.append("-m 1").append(this.separator);
        for (String fileSpec : fileList) {
            filelogArgs.append(fileSpec).append(this.separator);
        }
        String status = this.exec.executeWithInput(P4CliUtils.tokenizeCommand("filelog"), filelogArgs.toString(), "depotFile", new P4ZTagProcessor(){

            @Override
            public void processGroup(Map<String, String> pathProps) {
                String path = pathProps.get("depotFile");
                int index = 0;
                while (pathProps.containsKey("change" + index)) {
                    Long changeListId = Long.valueOf(pathProps.get("change" + index));
                    P4ChangeList changeList = (P4ChangeList)changeLists.get(changeListId);
                    if (changeList != null) {
                        P4ChangePath p4Path = changeList.getChangePath(path);
                        if (p4Path == null) {
                            int rev = Integer.parseInt(pathProps.get("rev" + index));
                            Logs.APP_LOG.warn((Object)("[" + P4Client.this.repoInfo.getRepositoryDescriptor() + "] Skipping path " + path + "#" + rev + " from filelog for " + changeListId + " as it is not included in the changelist's affected files list"));
                        } else {
                            if (!pathProps.containsKey("type" + index)) {
                                Logs.APP_LOG.warn((Object)("[" + P4Client.this.repoInfo.getRepositoryDescriptor() + "] Unable to determine file's type from filelog property map: " + pathProps));
                            }
                            p4Path.setFileType(pathProps.get("type" + index));
                            p4Path.setAction(pathProps.get("action" + index));
                            if (pathProps.containsKey("fileSize" + index)) {
                                p4Path.setFileSize(Long.parseLong(pathProps.get("fileSize" + index)));
                            }
                            int subIndex = 0;
                            while (pathProps.containsKey("how" + index + "," + subIndex)) {
                                String key = index + "," + subIndex;
                                String how = pathProps.get("how" + key);
                                if (how.endsWith(" from")) {
                                    String sourcePath = pathProps.get("file" + key);
                                    String startRev = pathProps.get("srev" + key);
                                    String endRev = pathProps.get("erev" + key);
                                    try {
                                        P4FileSpec sourceSpec = new P4FileSpec(sourcePath, startRev, endRev);
                                        String integrationAction = P4CliUtils.getWord(how);
                                        p4Path.setSourceInfo(integrationAction, sourceSpec);
                                    }
                                    catch (NumberFormatException e2) {
                                        Logs.APP_LOG.debug((Object)("[" + P4Client.this.repoInfo.getRepositoryDescriptor() + "] Unable to parse filespec: " + sourcePath + " " + startRev + ":" + endRev));
                                    }
                                }
                                ++subIndex;
                            }
                        }
                    }
                    ++index;
                }
            }
        });
        return status;
    }

    private void addChangesInformation(SortedMap<Long, P4ChangeList> changeLists) throws P4ClientException {
        DescribeProcessor.DescribeType describeType;
        if (changeLists.isEmpty()) {
            return;
        }
        Logs.APP_LOG.debug((Object)("[" + this.repoInfo.getRepositoryDescriptor() + "] Adding change information"));
        StringBuilder describeBase = new StringBuilder();
        if (this.repoInfo.isStoreDiffs()) {
            describeBase.append("describe -dn");
            describeType = DescribeProcessor.DescribeType.RCS;
        } else {
            describeBase.append("describe -ds");
            describeType = DescribeProcessor.DescribeType.SUMMARY;
        }
        StringBuilder describeCommand = new StringBuilder(describeBase);
        for (P4ChangeList changeList : changeLists.values()) {
            describeCommand.append(' ');
            describeCommand.append(changeList.getId());
        }
        DescribeProcessor processor = new DescribeProcessor(this.repoInfo, changeLists, describeType);
        String exitStatus = this.exec.executeCommand(P4CliUtils.tokenizeCommand(describeCommand.toString()), processor);
        if (exitStatus != null) {
            Logs.APP_LOG.warn((Object)("[" + this.repoInfo.getRepositoryDescriptor() + "] Problem executing " + describeCommand + ": " + exitStatus));
            Logs.APP_LOG.debug((Object)"Dropping to individual changelists");
            HashSet<Long> keys = new HashSet<Long>(changeLists.keySet());
            for (Long csid : keys) {
                if (this.repoStatus.isStopRequested()) {
                    return;
                }
                describeCommand.setLength(0);
                describeCommand.append((CharSequence)describeBase).append(' ').append(csid);
                exitStatus = this.exec.executeCommand(P4CliUtils.tokenizeCommand(describeCommand.toString()), processor);
                if (exitStatus == null) continue;
                Logs.APP_LOG.warn((Object)("[" + this.repoInfo.getRepositoryDescriptor() + "] Problem executing " + describeCommand + ": " + exitStatus));
                this.getShortChangeInfo(changeLists, csid, processor);
            }
        }
    }

    private void getShortChangeInfo(SortedMap<Long, P4ChangeList> changeLists, long csid, DescribeProcessor processor) throws P4ClientException {
        String command = "describe -s " + csid;
        String status = this.exec.executeCommand(P4CliUtils.tokenizeCommand(command), processor);
        if (status != null) {
            Logs.APP_LOG.warn((Object)("[" + this.repoInfo.getRepositoryDescriptor() + "] Problem executing " + command + ": " + status));
            Logs.APP_LOG.warn((Object)("Removing changelist " + csid));
            changeLists.remove(csid);
        }
    }

    public void streamContent(P4FileSpec fileSpec, String kopt, P4Visitor.ProcessOutputVisitor visitor) throws P4ClientException {
        List<String> command = P4CliUtils.tokenizeCommand("print -q");
        command.add(fileSpec.getPath() + '#' + fileSpec.getFileRev());
        String status = this.exec.executeAndStream(command, null, visitor);
        if (status != null) {
            throw new P4ClientException(status);
        }
    }

    public void streamContent(String path, long changeListId, String kopt, P4Visitor.ProcessOutputVisitor visitor) throws P4ClientException {
        List<String> command = P4CliUtils.tokenizeCommand("print -q");
        command.add(path + '@' + changeListId);
        String status = this.exec.executeAndStream(command, null, visitor);
        if (status != null) {
            throw new P4ClientException(status);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean exportContent(String path, File contentFile, long changeListId) throws FileNotFoundException, P4ClientException {
        final FileOutputStream fos = new FileOutputStream(contentFile);
        try {
            this.streamContent(path, changeListId, null, new P4Visitor.ProcessOutputVisitor(){

                public void visit(P4Process p4Process, InputStream is) throws P4Visitor.VisitorException {
                    try {
                        IOHelper.copyStream(is, (OutputStream)fos);
                    }
                    catch (IOException e2) {
                        throw new P4Visitor.VisitorException(e2);
                    }
                    finally {
                        IOHelper.close(is);
                    }
                }
            });
            boolean bl = true;
            return bl;
        }
        finally {
            IOHelper.close(fos);
        }
    }

    public void getBlame(final String fileSpec, final long changeListId, boolean isUnicode, final AnnotateCallBack callback) throws P4ClientException {
        List<String> command = P4CliUtils.tokenizeCommand("annotate -c -q");
        command.add(fileSpec + '@' + changeListId);
        P4OutputProcessor processor = isUnicode ? new P4OutputProcessor(){

            public void processOutput(P4Process process, InputStream is) throws IOException, P4ClientException {
                P4Client.this.processMixedBlameStream(process, is, callback);
            }
        } : new P4OutputLineProcessor(this.repoInfo.isUnicode() ? "UTF-8" : null){

            public void processLine(String infoLine) {
                if (infoLine.trim().length() != 0) {
                    int colonIndex = infoLine.indexOf(58);
                    if (colonIndex != -1) {
                        long changeList = Long.parseLong(infoLine.substring(0, colonIndex));
                        String text = infoLine.substring(colonIndex + 1);
                        callback.singleLine(changeList, text);
                    } else {
                        Logs.APP_LOG.debug((Object)("[" + P4Client.this.repoInfo.getRepositoryDescriptor() + "] Unable to find revision on annotated line [" + infoLine + "] when annotating " + fileSpec + '@' + changeListId));
                    }
                }
            }
        };
        String status = this.exec.executeCommand(command, processor);
        if (status != null) {
            throw new P4ClientException(status);
        }
    }

    private void processMixedBlameStream(P4Process process, InputStream is, AnnotateCallBack callback) throws IOException {
        long csid = this.readAnnotationLineNum(is);
        byte[] bom = new byte[2];
        int numRead = is.read(bom);
        if (numRead != 2) {
            throw new IOException("Stream does not include BOM");
        }
        boolean littleEndian = bom[0] == -1 && bom[1] == -2 ? true : (bom[0] == -2 && bom[1] == -1 ? false : false);
        int lineNumber = 1;
        String line = this.readUnicodeLine(is, littleEndian);
        callback.singleLine(csid, line);
        do {
            process.resetWatchdog();
            csid = this.readAnnotationLineNum(is);
            if (csid == -1L) continue;
            line = this.readUnicodeLine(is, littleEndian);
            if (line.length() > 0 && line.charAt(line.length() - 1) == '\r') {
                line = line.substring(0, line.length() - 1);
            }
            ++lineNumber;
            callback.singleLine(csid, line);
        } while (csid != -1L);
    }

    private long readAnnotationLineNum(InputStream is) throws IOException {
        int c2;
        StringBuilder numberBuffer = new StringBuilder();
        while ((c2 = is.read()) != -1 && c2 != 58) {
            numberBuffer.append((char)c2);
        }
        if (c2 == -1) {
            return -1L;
        }
        c2 = is.read();
        if (c2 != 32) {
            throw new IOException("Unexpected content in P4 annotation output");
        }
        return Long.parseLong(numberBuffer.toString());
    }

    private String readUnicodeLine(InputStream is, boolean littleEndian) throws IOException {
        int numRead;
        StringBuilder line = new StringBuilder();
        byte[] b2 = new byte[2];
        while ((numRead = is.read(b2)) != -1) {
            if (numRead != 2) {
                throw new IOException("Annotated output is malformed - unable to read Unicode character");
            }
            int c2 = littleEndian ? (b2[1] & 0xFF) << 8 | b2[0] : (b2[0] & 0xFF) << 8 | b2[1];
            if (c2 != 10) {
                line.append((char)c2);
            }
            if (c2 != 10) continue;
        }
        return line.toString();
    }

    public Map<String, Long> getBranchUpdateTimes() throws P4ClientException {
        final HashMap<String, Long> branchTimes = new HashMap<String, Long>();
        String status = this.exec.executeZTagCommand(P4CliUtils.tokenizeCommand("branches"), "branch", new P4ZTagProcessor(){

            @Override
            public void processGroup(Map<String, String> branchProps) {
                try {
                    branchTimes.put(branchProps.get("branch"), Long.valueOf(branchProps.get("Update")));
                }
                catch (Exception e2) {
                    Logs.APP_LOG.warn((Object)("[" + P4Client.this.repoInfo.getRepositoryDescriptor() + "] Unable to get branch update time: " + branchProps));
                }
            }
        });
        if (status != null) {
            throw new P4ClientException(status);
        }
        return branchTimes;
    }

    public P4BranchSpec getBranchSpec(String branchName) throws P4ClientException {
        List<String> command = P4CliUtils.tokenizeCommand("branch -o ");
        command.add(branchName);
        final P4BranchSpec branchSpec = new P4BranchSpec(branchName);
        String status = this.exec.executeFieldCommand(command, false, new P4FieldProcessor(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void processField(String fieldName, String fieldValue) {
                if (fieldName.equals("Owner")) {
                    branchSpec.setOwner(fieldValue);
                } else if (fieldName.equals("Description")) {
                    branchSpec.setDescription(fieldValue);
                } else if (fieldName.equals("View")) {
                    BufferedReader reader = new BufferedReader(new StringReader(fieldValue));
                    try {
                        String viewInfo;
                        while ((viewInfo = reader.readLine()) != null) {
                            int maptoIndex = viewInfo.lastIndexOf("//");
                            String from = viewInfo.substring(0, maptoIndex - 1).trim();
                            String to = viewInfo.substring(maptoIndex).trim();
                            P4BranchMapping mapping = new P4BranchMapping(from, to);
                            branchSpec.addMapping(mapping);
                        }
                    }
                    catch (IOException e2) {
                    }
                    finally {
                        IOHelper.close(reader);
                    }
                }
            }
        });
        if (status != null) {
            throw new P4ClientException(status);
        }
        return branchSpec;
    }

    public Map<String, P4Label> getLabels() throws P4ClientException {
        final HashMap<String, P4Label> labels = new HashMap<String, P4Label>();
        List<String> command = P4CliUtils.tokenizeCommand("labels");
        command.add(this.repoInfo.getBasePath() + '/' + "...");
        String status = this.exec.executeZTagCommand(command, "label", new P4ZTagProcessor(){

            @Override
            public void processGroup(Map<String, String> labelProps) {
                P4Label label = new P4Label(labelProps.get("label"));
                label.setUpdateTime(Long.parseLong(labelProps.get("Update")));
                label.setAccessTime(Long.parseLong(labelProps.get("Access")));
                labels.put(label.getName(), label);
            }
        });
        if (status != null) {
            Logs.APP_LOG.error((Object)("[" + this.repoInfo.getRepositoryDescriptor() + "] Unable to get Perforce label information - command status: " + status));
        }
        return labels;
    }

    public P4Label getLabel(final String name) throws P4ClientException {
        P4Label label;
        List<String> command = P4CliUtils.tokenizeCommand("labels");
        String status = this.exec.executeZTagCommand(command, "label", new P4ZTagProcessor(label = new P4Label(name)){
            final /* synthetic */ P4Label val$label;
            {
                this.val$label = p4Label;
            }

            @Override
            public void processGroup(Map<String, String> labelProps) {
                String labelName = labelProps.get("label");
                if (labelName.equals(name)) {
                    this.val$label.setUpdateTime(Long.parseLong(labelProps.get("Update")));
                    this.val$label.setAccessTime(Long.parseLong(labelProps.get("Access")));
                }
            }
        });
        if (status != null) {
            Logs.APP_LOG.error((Object)("[" + this.repoInfo.getRepositoryDescriptor() + "] Unable to get Perforce label information for " + name + " - command status: " + status));
        }
        return label;
    }

    public void visitLabels(List<Path> includedPaths, P4Visitor.LabelVisitor visitor) throws P4ClientException {
        if (includedPaths.isEmpty()) {
            this.visitPathLabels(visitor, new Path());
        } else {
            for (Path path : includedPaths) {
                this.visitPathLabels(visitor, path);
            }
        }
    }

    private void visitPathLabels(final P4Visitor.LabelVisitor visitor, Path path) throws P4ClientException {
        List<String> command = P4CliUtils.tokenizeCommand("labels");
        String serverPath = this.repoInfo.getServerPath(path, -1L);
        command.add(serverPath + '/' + "...");
        String status = this.exec.executeZTagCommand(command, "label", new P4ZTagProcessor(){

            @Override
            public void processGroup(Map<String, String> labelProps) {
                P4Label label = new P4Label(labelProps.get("label"));
                label.setUpdateTime(Long.parseLong(labelProps.get("Update")));
                label.setAccessTime(Long.parseLong(labelProps.get("Access")));
                visitor.visit(label);
            }
        });
        if (status != null) {
            Logs.APP_LOG.error((Object)("[" + this.repoInfo.getRepositoryDescriptor() + "] Unable to get Perforce label information - command status: " + status));
        }
    }

    public void visitLabelFiles(String label, P4Visitor.LabeledFileVisitor visitor) throws P4ClientException {
        this.visitLabelFilesByTree(label, this.repoInfo.getBasePath(), visitor);
    }

    private void visitLabelFilesByTree(final String label, String dir, final P4Visitor.LabeledFileVisitor visitor) throws P4ClientException {
        List<String> command = P4CliUtils.tokenizeCommand("files");
        command.add(dir + '/' + "..." + "@" + label);
        String status = this.exec.executeZTagCommand(command, "depotFile", new P4ZTagProcessor(){

            @Override
            public void processGroup(Map<String, String> fileInfo) {
                P4FileSpec fileSpec = new P4FileSpec(fileInfo.get("depotFile"), Integer.parseInt(fileInfo.get("rev")));
                visitor.visit(label, fileSpec);
            }
        });
        if (status != null) {
            Logs.APP_LOG.warn((Object)("[" + this.repoInfo.getRepositoryDescriptor() + "] Unable to load label information for \"" + label + "\" on directory " + dir + ", due to status = " + status));
            this.visitLabelFilesByDirTrees(label, dir, visitor);
        }
    }

    private void visitLabelFilesByDirTrees(final String label, String dir, final P4Visitor.LabeledFileVisitor visitor) throws P4ClientException {
        this.visitLabelFilesinDir(label, dir, visitor);
        List<String> command = P4CliUtils.tokenizeCommand("dirs");
        command.add(dir + "/*");
        String status = this.exec.executeZTagCommand(command, "dir", new P4ZTagProcessor(){

            @Override
            public void processGroup(Map<String, String> dirInfo) throws P4ClientException {
                P4Client.this.visitLabelFilesByTree(label, dirInfo.get("dir"), visitor);
            }
        });
        if (status != null) {
            Logs.APP_LOG.warn((Object)("[" + this.repoInfo.getRepositoryDescriptor() + "] Unable to list dirs for " + dir + " - skipping determination of label \"" + label + "\" in this dir" + ", due to status = " + status));
        }
    }

    private void visitLabelFilesinDir(final String label, String dir, final P4Visitor.LabeledFileVisitor visitor) throws P4ClientException {
        List<String> command = P4CliUtils.tokenizeCommand("files");
        command.add(dir + "/*@" + label);
        String status = this.exec.executeZTagCommand(command, "depotFile", new P4ZTagProcessor(){

            @Override
            public void processGroup(Map<String, String> fileInfo) {
                P4FileSpec fileSpec = new P4FileSpec(fileInfo.get("depotFile"), Integer.parseInt(fileInfo.get("rev")));
                visitor.visit(label, fileSpec);
            }
        });
        if (status != null) {
            Logs.APP_LOG.warn((Object)("[" + this.repoInfo.getRepositoryDescriptor() + "] Unable to get list of files labeled with \"" + label + "\" in dir " + dir + ", due to status = " + status));
        }
    }

    public void streamMultipleContent(Set<P4FileSpec> fileSpecs, P4Visitor.ProcessOutputVisitor visitor) throws P4ClientException {
        HashSet<P4FileSpec> specList = new HashSet<P4FileSpec>(fileSpecs);
        int numPaths = 0;
        StringBuilder printArgs = new StringBuilder();
        for (P4FileSpec fileSpec : specList) {
            if (printArgs.length() != 0) {
                printArgs.append(this.separator);
            }
            printArgs.append(fileSpec);
            if (++numPaths <= this.maxPrint) continue;
            this.execMultiPrint(printArgs, visitor);
            printArgs.setLength(0);
            numPaths = 0;
        }
        String status = null;
        if (numPaths != 0) {
            status = this.execMultiPrint(printArgs, visitor);
        }
        if (status != null) {
            throw new P4ClientException(status);
        }
    }

    private String execMultiPrint(StringBuilder printArgs, P4Visitor.ProcessOutputVisitor visitor) throws P4ClientException {
        String exitStatus = null;
        if (printArgs.length() != 0) {
            exitStatus = this.exec.executeAndStream(P4CliUtils.tokenizeCommand("print"), printArgs.toString(), visitor);
        }
        return exitStatus;
    }

    public int getMaxPrintBytes() {
        return this.maxPrintBytes;
    }

    public void cancel() {
        this.exec.cancel();
    }

    public void setRepoStatus(RepositoryStatus repoStatus) {
        this.repoStatus = repoStatus;
    }
}

