/*
 * Decompiled with CFR 0.152.
 */
package com.cenqua.fisheye.rep;

import com.cenqua.fisheye.Path;
import com.cenqua.fisheye.cache.RecentChangesParams;
import com.cenqua.fisheye.infinitydb.query3.AndQuery3;
import com.cenqua.fisheye.infinitydb.query3.Query3;
import com.cenqua.fisheye.logging.Logs;
import com.cenqua.fisheye.lucene.LuceneConnection;
import com.cenqua.fisheye.rep.ChangeSet;
import com.cenqua.fisheye.rep.DbException;
import com.cenqua.fisheye.rep.DirInfo;
import com.cenqua.fisheye.rep.impl.CommonQuery3Helper;
import com.cenqua.fisheye.rep.impl.CommonSchema;
import com.cenqua.fisheye.util.CompareUtil;
import com.cenqua.fisheye.util.MinMaxLongRange;
import com.cenqua.obfuscate.idbk4uide._AndSpace;
import com.cenqua.obfuscate.idbk4uide._Cu;
import com.cenqua.obfuscate.idbk4uide._ItemSpace;
import com.cenqua.obfuscate.idbk4uide._ItemSubspace;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class RecentChangesSearcher {
    private final LuceneConnection conn;
    private final _ItemSpace db;
    private final RecentChangesParams params;
    private long mMinDate;
    private long mMaxDate;
    private final int mMaxReturn;
    private final Path searchDir;
    private final LinkedHashSet<String> mResults;
    private _ItemSpace mMatchingRevids;
    private final int mSearchDirection;
    private final ChangeSet mMaxChangeset;
    private final ChangeSet mMinChangeset;
    private String mLastChangeset = null;
    private boolean caseSensitive;

    public RecentChangesSearcher(LuceneConnection conn, _ItemSpace db, RecentChangesParams params, DirInfo di, boolean caseSensitive) {
        MinMaxLongRange range;
        this.conn = conn;
        this.db = db;
        this.params = params;
        this.mMinDate = params.getMinDate();
        this.mMaxDate = params.getMaxDate();
        this.mMaxReturn = params.getMaxReturn();
        this.searchDir = params.getPath();
        this.mMaxChangeset = params.getMaxChangeset();
        this.mMinChangeset = params.getMinChangeset();
        this.mSearchDirection = params.getSearchDirection();
        this.caseSensitive = caseSensitive;
        this.mResults = new LinkedHashSet(Math.min(this.mMaxReturn, 1000) + 1);
        if (this.mMaxChangeset != null) {
            this.mMaxDate = Math.min(this.mMaxDate, this.mMaxChangeset.getDate());
        }
        if (this.mMinChangeset != null) {
            this.mMinDate = Math.max(this.mMinDate, this.mMinChangeset.getDate());
        }
        if (di != null && !this.searchDir.isRoot() && (range = di.getSubTreeDateRange()).isSet()) {
            this.mMaxDate = Math.min(this.mMaxDate, range.getMax());
            this.mMinDate = Math.max(this.mMinDate, range.getMin());
        }
    }

    public List<String> findRecentChangeSets() throws DbException, IOException {
        long t0 = System.currentTimeMillis();
        AndQuery3 q = this.params.getFile() != null ? CommonQuery3Helper.findRevisionsAtPathQuery3(this.params.getFile(), this.isCaseSensitive()) : (this.params.isRecursive() ? CommonQuery3Helper.findRevisionsUnderDirQuery3(this.searchDir, this.isCaseSensitive()) : CommonQuery3Helper.findRevisionsInDirQuery3(this.searchDir, this.isCaseSensitive()));
        Query3 constraint = this.params.getConstraint();
        if (constraint != null) {
            q.addClause(constraint);
        }
        long t1 = System.currentTimeMillis();
        this.mMatchingRevids = q.asItemSpace(this.db, this.conn);
        long t2 = System.currentTimeMillis();
        this.traverseByDate(this.db);
        long t3 = System.currentTimeMillis();
        ArrayList<String> results = new ArrayList<String>(this.mResults.size());
        for (String csid : this.mResults) {
            results.add(csid);
        }
        if (this.mSearchDirection == 1) {
            Collections.reverse(results);
        }
        long t4 = System.currentTimeMillis();
        if (Logs.PERF_LOG.isDebugEnabled()) {
            Logs.PERF_LOG.debug((Object)("findRecentChangeSets()  on " + this.searchDir + " nresults=" + results.size() + " in " + (t1 - t0) + "ms + " + (t2 - t1) + "ms using " + q + " + " + (t3 - t2) + "ms + " + (t4 - t3) + "ms"));
        }
        return results;
    }

    private void traverseByDate(_ItemSpace db) throws DbException, IOException {
        boolean forward;
        long endTerm;
        long startTerm;
        if (this.mSearchDirection == 0) {
            startTerm = this.mMaxDate;
            endTerm = this.mMinDate;
            forward = false;
        } else {
            startTerm = this.mMinDate;
            endTerm = this.mMaxDate;
            forward = true;
        }
        _Cu cu = _Cu.alloc();
        cu.append(CommonSchema.E_DATE_TO_REVID);
        int pl = cu.length();
        cu.append(startTerm);
        if (!forward) {
            cu.appendInfinity();
        }
        _Cu revidCu = _Cu.alloc();
        _AndSpace union = new _AndSpace();
        while (db.move(cu, pl, false, forward, false) >= 0 && this.mResults.size() < this.mMaxReturn) {
            int p = pl;
            long currentdate = cu.longAt(p);
            if (forward ? currentdate > endTerm : currentdate < endTerm) break;
            p = cu.skipLong(p);
            cu.setLength(p);
            _ItemSubspace revidsAtDate = new _ItemSubspace(db, cu);
            union.clearInputs();
            union.add(this.mMatchingRevids).add(revidsAtDate);
            revidCu.clear();
            while (union.next(revidCu)) {
                int revid = (int)revidCu.longAt(0);
                this.addToResults(this.extractResult(revid), currentdate);
                if (this.mResults.size() < this.mMaxReturn) continue;
                break;
            }
            if (forward) {
                cu.incrementSuffix(pl);
                continue;
            }
            cu.decrementSuffix(pl);
        }
    }

    private void addToResults(String csid, long date) {
        if (csid == null) {
            return;
        }
        if (csid.equals(this.mLastChangeset)) {
            return;
        }
        if (this.mResults.contains(csid)) {
            return;
        }
        if (this.mMaxChangeset != null && !RecentChangesSearcher.checkBound(this.mMaxChangeset, csid, date, this.params.isMaxChangesetInclusive(), true)) {
            return;
        }
        if (this.mMinChangeset != null && !RecentChangesSearcher.checkBound(this.mMinChangeset, csid, date, this.params.isMinChangesetInclusive(), false)) {
            return;
        }
        this.mResults.add(csid);
        this.mLastChangeset = csid;
    }

    private static boolean checkBound(ChangeSet bound, String csid, long date, boolean inclusive, boolean lt) {
        int idcmp = CompareUtil.compare((Comparable)((Object)csid), bound.getId());
        if (idcmp == 0) {
            return inclusive;
        }
        int datecmp = CompareUtil.compareTo(date, bound.getDate());
        if (datecmp == 0) {
            datecmp = idcmp;
        }
        return lt ? datecmp < 0 : datecmp > 0;
    }

    public boolean isCaseSensitive() {
        return this.caseSensitive;
    }

    protected abstract String extractResult(int var1) throws IOException, DbException;
}

