/*
 * Decompiled with CFR 0.152.
 */
package com.cenqua.fisheye.rep;

import com.cenqua.fisheye.AllowRules;
import com.cenqua.fisheye.AppConfig;
import com.cenqua.fisheye.Path;
import java.io.File;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class RepositoryInfo {
    private boolean contentIndexingEnabled = true;
    private AllowRules allowRules;
    private long startRev;
    private String repositoryName;
    private String importMode = "none";
    private long commandTimeout;
    private boolean storeDiffs;
    private File repoTempDir;

    public void setStartRev(long startRev) {
        this.startRev = startRev;
    }

    public long getStartRev() {
        return this.startRev;
    }

    public void setImportMode(String importMode) {
        this.importMode = importMode;
    }

    public String getImportMode() {
        return this.importMode;
    }

    public boolean isContentIndexingEnabled() {
        return this.contentIndexingEnabled;
    }

    public void setContentIndexingEnabled(boolean contentIndexingEnabled) {
        this.contentIndexingEnabled = contentIndexingEnabled;
    }

    public String getName() {
        return this.repositoryName;
    }

    public void setRepositoryName(String repositoryName) {
        this.repositoryName = repositoryName;
        this.repoTempDir = new File(AppConfig.getTempDir(), repositoryName);
        this.repoTempDir.mkdirs();
    }

    public String getRepositoryName() {
        return this.repositoryName;
    }

    public File getRepoTempDir() {
        return this.repoTempDir;
    }

    public void setAllowRules(AllowRules allowRules) {
        this.allowRules = allowRules;
    }

    public boolean isPathInRepo(Path localPath, long revision) {
        return (revision == -1L || revision >= this.startRev) && this.isPathInRepo(localPath);
    }

    public boolean isPathInRepo(String serverPath, long revision) {
        return this.isPathInRepo(this.getLocalPath(serverPath, revision), revision);
    }

    public boolean isPathInRepo(Path localPath) {
        if (localPath.isAbove()) {
            return false;
        }
        if (this.allowRules != null) {
            Path path = localPath;
            while (!path.isRoot()) {
                if (this.allowRules.isIgnored(path)) {
                    return false;
                }
                path = path.getParent();
            }
        }
        return true;
    }

    public void setCommandTimeout(long commandTimeout) {
        this.commandTimeout = commandTimeout;
    }

    public long getCommandTimeout() {
        return this.commandTimeout;
    }

    public abstract String getServerPath(Path var1, long var2);

    public abstract Path getLocalPath(String var1, long var2);

    public abstract String getRepositoryDescriptor();

    public boolean isStoreDiffs() {
        return this.storeDiffs;
    }

    public void setStoreDiffs(boolean storeDiffs) {
        this.storeDiffs = storeDiffs;
    }

    public List<Path> getIncludedPaths() {
        return this.allowRules.getIncludes();
    }
}

