/*
 * Decompiled with CFR 0.152.
 */
package com.cenqua.fisheye.rep.ping;

import com.cenqua.fisheye.rep.RepositoryHandle;
import java.util.ArrayList;
import java.util.List;

public abstract class PingRequest
implements Runnable {
    private RepositoryHandle handle;
    private List<PingRequest> subRequests = new ArrayList<PingRequest>();
    private int priority;
    private final Callback callback;

    protected PingRequest(RepositoryHandle handle, int priority) {
        this(handle, priority, null);
    }

    protected PingRequest(RepositoryHandle handle, int priority, Callback callback) {
        this.handle = handle;
        this.priority = priority;
        this.callback = callback;
    }

    public final void run() {
        this.handle.queuePingRequest(this);
    }

    public void combine(PingRequest request) {
        if (request.hasCallback()) {
            this.subRequests.add(request);
        }
    }

    public boolean hasCallback() {
        return this.callback != null;
    }

    private void done() {
        for (PingRequest subRequest : this.subRequests) {
            subRequest.done();
        }
        if (this.callback != null) {
            this.callback.done();
        }
    }

    public RepositoryHandle getHandle() {
        return this.handle;
    }

    public int getPriority() {
        return this.priority;
    }

    public final void process() {
        this.doRequest();
        this.done();
    }

    public boolean canCombine(PingRequest request) {
        return request.getClass() == this.getClass();
    }

    protected abstract void doRequest();

    public abstract String getDescription();

    public static interface Callback {
        public void done();
    }
}

