/*
 * Decompiled with CFR 0.152.
 */
package com.cenqua.fisheye.svn;

import com.cenqua.fisheye.cache.BaseRevisionCache;
import com.cenqua.fisheye.cache.RevisionCache;
import com.cenqua.fisheye.config.ConfigException;
import com.cenqua.fisheye.cvsrep.search.SearchManager;
import com.cenqua.fisheye.logging.Logs;
import com.cenqua.fisheye.lucene.LuceneConnection;
import com.cenqua.fisheye.rep.DbException;
import com.cenqua.fisheye.rep.NetworkRepositorySettings;
import com.cenqua.fisheye.rep.RepositoryClientException;
import com.cenqua.fisheye.rep.RepositoryEngine;
import com.cenqua.fisheye.svn.SvnLogicalPathMatcher;
import com.cenqua.fisheye.svn.SvnPasswordSupplier;
import com.cenqua.fisheye.svn.SvnRepositoryConfig;
import com.cenqua.fisheye.svn.SvnRepositoryInfo;
import com.cenqua.fisheye.svn.SvnRepositoryScanner;
import com.cenqua.fisheye.util.Throttle;
import java.io.File;
import java.io.IOException;
import org.apache.lucene.analysis.Analyzer;

public class SvnRepositoryEngine
extends RepositoryEngine {
    private final SvnRepositoryScanner scanner;

    public SvnRepositoryEngine(SvnRepositoryConfig config) {
        super(config);
        NetworkRepositorySettings networkSettings = config.getNetworkSettings();
        SvnPasswordSupplier passwordSupplier = new SvnPasswordSupplier(networkSettings.getUsername(), networkSettings.getPassword());
        float throttleLimit = networkSettings.getCps();
        Throttle throttle = new Throttle();
        if (throttleLimit > 0.0f) {
            throttle.setOperationsPerSecond(throttleLimit);
        }
        SvnRepositoryInfo repInfo = config.createRepositoryInfo();
        this.scanner = new SvnRepositoryScanner(config.getName(), repInfo, passwordSupplier, throttle, this.getStatus());
        this.scanner.setMasterAnalyzer((Analyzer)config.getMasterAnalyzer());
        this.scanner.setAccessKey(config.getAccessKey());
        this.scanner.setCommitBlockSize(config.getBlocksize());
    }

    public void startEngine() throws IOException, DbException {
        this.scanner.setCacheSize(this.getInfDbCacheSize());
        this.scanner.setCacheDir(this.cacheDir);
        this.scanner.start();
    }

    protected boolean wantInitialSlurp() {
        return this.scanner.wantsInitialSlurp();
    }

    public synchronized void rescan(String start, String end) throws UnsupportedOperationException, RepositoryClientException, DbException {
        this.scanner.updateRevisions(Long.parseLong(start), Long.parseLong(end));
    }

    public void doSlurp() throws DbException, ConfigException {
        this.scanner.ping();
    }

    protected long getPollPeriod() {
        return this.getSvnConfig().getNetworkSettings().getPollPeriod();
    }

    public SearchManager getSearchManager() {
        return this.scanner.getSearchManager();
    }

    public LuceneConnection getLuceneConnection() {
        return this.scanner.getLuceneConnection();
    }

    public RevisionCache getRevisionCache() {
        return this.scanner.getCache();
    }

    protected BaseRevisionCache getBaseRevisionCache() {
        return this.scanner.getSvnCache();
    }

    public void forceClose() {
        this.scanner.forceClose();
        Logs.APP_LOG.debug((Object)("Closed engine " + this.getName()));
    }

    public void requestFullscan() {
    }

    private SvnRepositoryConfig getSvnConfig() {
        return (SvnRepositoryConfig)this.getCfg();
    }

    public void loadDump(File dumpfile) throws IOException, RepositoryClientException, DbException {
        this.scanner.loadDump(dumpfile);
    }

    public SvnLogicalPathMatcher getPathMatcher() {
        return this.getSvnConfig().getPathMatcher();
    }

    public SvnRepositoryScanner getScanner() {
        return this.scanner;
    }

    public void requestStop() {
        this.scanner.requestStop();
    }

    public static class RescanRequest {
        private final long start;
        private final long end;

        public RescanRequest(long start, long end) {
            this.start = start;
            this.end = end;
        }

        public long getStart() {
            return this.start;
        }

        public long getEnd() {
            return this.end;
        }
    }
}

