/*
 * Decompiled with CFR 0.152.
 */
package com.cenqua.fisheye.svn.diff;

import com.cenqua.fisheye.Path;
import com.cenqua.fisheye.diff.Hunk;
import com.cenqua.fisheye.svn.diff.ChangeInfo;
import com.cenqua.fisheye.svn.diff.SvnDiffAdapter;
import com.cenqua.fisheye.util.diff.HunkFactory;
import com.cenqua.fisheye.util.diff.SectionSpec;
import java.util.HashMap;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DiffListener
extends SvnDiffAdapter {
    private Map<Path, ChangeInfo> changeInfos = new HashMap<Path, ChangeInfo>();
    private HunkFactory hunkFactory = new HunkFactory(){

        public void addHunk(Hunk hunk) {
            DiffListener.this.getPathChangeInfo(DiffListener.this.currentSectionPath).addHunk(hunk);
        }
    };
    private Path currentSectionPath;

    private ChangeInfo getPathChangeInfo(Path path) {
        if (!this.changeInfos.containsKey(path)) {
            this.changeInfos.put(path, new ChangeInfo());
        }
        return this.getInfo(path);
    }

    @Override
    public void indexMark(Path path) {
        this.getPathChangeInfo(path).setFileDiff(true);
    }

    @Override
    public void addLine(Path path, String line) {
        this.getPathChangeInfo(path).incAdded(1);
        this.hunkFactory.addLine();
    }

    @Override
    public void removeLine(Path path, String line) {
        this.getPathChangeInfo(path).incRemoved(1);
        this.hunkFactory.removeLine();
    }

    @Override
    public void contextLine(Path path, String line) {
        this.hunkFactory.contextLine();
    }

    @Override
    public void updateProperty(Path path, String name, String value) {
        this.getPathChangeInfo(path).updateProperty(name, value);
    }

    @Override
    public void section(Path path, SectionSpec spec) {
        this.currentSectionPath = path;
        this.hunkFactory.startSection(spec);
    }

    @Override
    public void endSection() {
        this.hunkFactory.endSection();
    }

    @Override
    public void removeProperty(Path path, String name, String value) {
        this.getPathChangeInfo(path).removeProperty(name);
    }

    public ChangeInfo getInfo(Path path) {
        return this.changeInfos.get(path);
    }

    public void reset() {
        this.changeInfos.clear();
    }

    public Map<Path, ChangeInfo> getChangeInfos() {
        return this.changeInfos;
    }

    public void endSection(Path path) {
    }
}

