/*
 * Decompiled with CFR 0.152.
 */
package com.cenqua.fisheye.svn.dump;

import java.io.FilterInputStream;
import java.io.IOException;
import java.io.InputStream;

public class DumpInputStream
extends FilterInputStream {
    private int readAhead = -1;
    private String pushBackLine = null;
    int lineNumber = 1;

    public DumpInputStream(InputStream in) {
        super(in);
    }

    public int read() throws IOException {
        int result;
        if (this.readAhead != -1) {
            result = this.readAhead;
            this.readAhead = -1;
        } else {
            result = super.read();
        }
        return result;
    }

    private void pushBack(int ch) {
        this.readAhead = ch;
    }

    public String readLine() throws IOException {
        if (this.pushBackLine != null) {
            String result = this.pushBackLine;
            this.pushBackLine = null;
            return result;
        }
        int i2 = this.read();
        if (i2 == -1) {
            return null;
        }
        StringBuffer buffer = new StringBuffer();
        while (i2 != -1) {
            if (i2 == 13) {
                i2 = this.read();
                if (i2 == 10) break;
                this.pushBack(i2);
                break;
            }
            if (i2 == 10) break;
            buffer.append((char)i2);
            i2 = this.read();
        }
        return buffer.toString();
    }

    public String readNonBlankLine() throws IOException {
        String line;
        while ((line = this.readLine()) != null && line.trim().length() == 0) {
        }
        return line;
    }

    public String peekNonBlankLine() throws IOException {
        String line = this.readNonBlankLine();
        if (line != null) {
            this.pushBackLine(line);
        }
        return line;
    }

    public String readStringHeader(String header) throws IOException {
        return this.readStringHeader(header, this.readNonBlankLine());
    }

    public String readStringHeader(String header, String line) throws IOException {
        if (!line.startsWith(header)) {
            throw new IOException("Expected \"" + header + "\" but got \"" + line + "\"");
        }
        int headerLength = header.length();
        if (line.charAt(headerLength) == ':') {
            ++headerLength;
        }
        return line.substring(headerLength).trim();
    }

    public int readIntHeader(String header) throws IOException {
        return this.readIntHeader(header, this.readNonBlankLine());
    }

    public int readIntHeader(String header, String line) throws IOException {
        return Integer.parseInt(this.readStringHeader(header, line).trim());
    }

    public void pushBackLine(String line) {
        this.pushBackLine = line;
    }
}

