/*
 * Decompiled with CFR 0.152.
 */
package com.cenqua.fisheye.syntax;

import com.cenqua.fisheye.syntax.Region;
import com.cenqua.fisheye.syntax.RegionListVisitor;
import com.cenqua.fisheye.syntax.SortedRegionSet;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.ListIterator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RegionList {
    private SortedRegionSet regions = new SortedRegionSet();

    public int size() {
        return this.regions.size();
    }

    public void clear() {
        this.regions.clear();
    }

    public void merge(RegionList otherRegions) {
        Iterator<Region> i2 = otherRegions.iterator();
        while (i2.hasNext()) {
            this.add(i2.next());
        }
    }

    public void add(Region inputRegion) {
        LinkedList<Region> toAdd = new LinkedList<Region>();
        toAdd.add(inputRegion);
        Iterator overlapping = this.regions.iterateBetween(inputRegion.getStart(), inputRegion.getEnd());
        while (overlapping.hasNext()) {
            Region existing = (Region)overlapping.next();
            ListIterator<Region> i2 = toAdd.listIterator();
            while (i2.hasNext()) {
                Region rest;
                Region adding = (Region)i2.next();
                if (!adding.overlapsNotNested(existing)) continue;
                i2.remove();
                Region inter = existing.intersection(adding);
                if (inter == null) continue;
                i2.add(inter);
                if (adding.getStart() < existing.getStart()) {
                    rest = new Region(adding.getStart(), existing.getStart(), adding.getProperties());
                    i2.add(rest);
                }
                if (adding.getEnd() <= existing.getEnd()) continue;
                rest = new Region(existing.getEnd(), adding.getEnd(), adding.getProperties());
                i2.add(rest);
            }
        }
        for (Region region : toAdd) {
            this.regions.add(region);
        }
    }

    public void addAll(RegionList regionList) {
        this.regions.addAll(regionList.regions);
    }

    public void translate(int dx) {
        SortedRegionSet newList = new SortedRegionSet();
        Iterator<Region> it = this.regions.iterator();
        while (it.hasNext()) {
            Region reg = it.next();
            newList.add(reg.translate(dx));
        }
        this.regions = newList;
    }

    public Iterator<Region> iterator() {
        return this.regions.iterator();
    }

    public void visitRegions(RegionListVisitor visitor) throws IOException {
        visitor.start();
        LinkedList<Region> visitEnd = new LinkedList<Region>();
        Iterator<Region> regs = this.regions.iterator();
        while (regs.hasNext()) {
            Region reg = regs.next();
            ListIterator it = visitEnd.listIterator();
            while (it.hasNext()) {
                Region regEnd = (Region)it.next();
                if (regEnd.getEnd() > reg.getStart()) continue;
                visitor.regionEnd(regEnd);
                it.remove();
            }
            visitor.regionStart(reg);
            visitEnd.addFirst(reg);
        }
        ListIterator it = visitEnd.listIterator();
        while (it.hasNext()) {
            Region regEnd = (Region)it.next();
            visitor.regionEnd(regEnd);
        }
        visitor.end();
    }

    public RegionList getSubset(int startOffset, int endOffset) {
        Region subsetBounds = new Region(startOffset, endOffset);
        RegionList subset = new RegionList();
        Iterator regs = this.regions.iterateBetween(startOffset, endOffset);
        while (regs.hasNext()) {
            int end;
            int start;
            Region region = (Region)regs.next();
            if (subsetBounds.nests(region)) {
                subset.add(region);
                continue;
            }
            if (!region.nests(subsetBounds) && !region.overlapsNotNested(subsetBounds) || (start = Math.max(region.getStart(), startOffset)) >= (end = Math.min(region.getEnd(), endOffset))) continue;
            Region part = new Region(start, end, region.getProperties());
            subset.add(part);
        }
        return subset;
    }

    public List<Region> asList() {
        ArrayList<Region> l = new ArrayList<Region>(this.regions.size());
        Iterator<Region> i2 = this.regions.iterator();
        while (i2.hasNext()) {
            l.add(i2.next());
        }
        return l;
    }

    public String toString() {
        return "RegionList: " + this.regions.size() + " regions. " + this.regions.toString();
    }
}

