/*
 * Decompiled with CFR 0.152.
 */
package com.cenqua.fisheye.user;

import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class LoginCookieToken {
    private static final Pattern DECODER = Pattern.compile("^([^:]+):(\\d+):(.+)");
    private final long loginId;
    private final String username;
    protected String rnd;

    public LoginCookieToken(long loginId, String username, String rnd) {
        this.loginId = loginId;
        this.username = username;
        this.rnd = rnd;
    }

    public long getLoginId() {
        return this.loginId;
    }

    public String getUsername() {
        return this.username;
    }

    public String getRnd() {
        return this.rnd;
    }

    public String encode() {
        return this.username + ":" + this.loginId + ":" + this.rnd;
    }

    public static LoginCookieToken decode(String value) {
        Matcher matcher = DECODER.matcher(value);
        if (matcher.matches()) {
            return new LoginCookieToken(Long.parseLong(matcher.group(2)), matcher.group(1), matcher.group(3));
        }
        return null;
    }
}

