/*
 * Decompiled with CFR 0.152.
 */
package com.cenqua.fisheye.user.crowd;

import com.atlassian.crowd.integration.authentication.PrincipalAuthenticationContext;
import com.atlassian.crowd.integration.exception.InvalidAuthenticationException;
import com.atlassian.crowd.integration.exception.ObjectNotFoundException;
import com.atlassian.crowd.integration.http.HttpAuthenticatorFactory;
import com.atlassian.crowd.integration.service.soap.client.SecurityServerClientFactory;
import com.atlassian.crowd.integration.soap.SOAPGroup;
import com.atlassian.crowd.integration.soap.SOAPPrincipal;
import com.cenqua.fisheye.config1.CrowdAuthConfigType;
import com.cenqua.fisheye.logging.Logs;
import com.cenqua.fisheye.rep.RepositoryHandle;
import com.cenqua.fisheye.user.BaseAuth;
import com.cenqua.fisheye.user.LoginCookie;
import com.cenqua.fisheye.user.UserLogin;
import com.cenqua.fisheye.user.crowd.CrowdAuthTok;
import com.cenqua.fisheye.user.crowd.GroupMembershipCache;
import com.cenqua.fisheye.util.PropertiesUtil;
import com.cenqua.fisheye.util.StringUtil;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Properties;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.log4j.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CrowdAuth
extends BaseAuth {
    private static final long GROUP_CACHE_TTL = 120000L;
    private final boolean autoadd;
    private final boolean ssoEnabled;
    private final GroupMembershipCache gcache = new GroupMembershipCache(120000L);

    public CrowdAuth(CrowdAuthConfigType cfg) {
        this(cfg, Logs.APP_LOG, Logs.PERF_LOG);
    }

    public CrowdAuth(CrowdAuthConfigType cfg, Logger appLog, Logger perfLog) {
        super(appLog, perfLog);
        this.autoadd = cfg.getAutoAdd();
        this.ssoEnabled = cfg.getSsoEnabled();
        String props = cfg.getCrowdProperties();
        if (props != null) {
            CrowdAuth.setupProps(props);
        }
    }

    private static void setupProps(String props) {
        Properties properties = new Properties();
        properties.setProperty("session.validationinterval", "2");
        PropertiesUtil.loadFromString(properties, props);
        properties.setProperty("session.lastvalidation", "fisheye.crowd.session.lastvalidation");
        SecurityServerClientFactory.getSecurityServerClient().getClientProperties().updateProperties(properties);
    }

    @Override
    public void close() {
    }

    @Override
    public boolean getAutoAdd() {
        return this.autoadd;
    }

    @Override
    public BaseAuth.AuthTok checkPassword(String username, String password, HttpServletRequest request, HttpServletResponse response) {
        try {
            SOAPPrincipal principal;
            String token;
            long t0 = System.currentTimeMillis();
            if (request == null || response == null || !this.ssoEnabled) {
                PrincipalAuthenticationContext authenticationContext = HttpAuthenticatorFactory.getHttpAuthenticator().getPrincipalAuthenticationContext(null, null, username, password);
                token = SecurityServerClientFactory.getSecurityServerClient().authenticatePrincipal(authenticationContext);
                principal = SecurityServerClientFactory.getSecurityServerClient().findPrincipalByToken(token);
            } else {
                HttpAuthenticatorFactory.getHttpAuthenticator().authenticate(request, response, username, password);
                principal = HttpAuthenticatorFactory.getHttpAuthenticator().getPrincipal(request);
                token = HttpAuthenticatorFactory.getHttpAuthenticator().getToken(request);
            }
            long t1 = System.currentTimeMillis();
            if (Logs.PERF_LOG.isDebugEnabled()) {
                Logs.PERF_LOG.debug((Object)("checkPassword() in " + (t1 - t0) + "ms"));
            }
            return this.generateAuthToken(principal, this.ssoEnabled ? token : null);
        }
        catch (InvalidAuthenticationException e2) {
            this.appLog.info((Object)"user not found", (Throwable)e2);
            return null;
        }
        catch (Exception e3) {
            this.appLog.warn((Object)"Problem communicating with Crowd", (Throwable)e3);
            return null;
        }
    }

    @Override
    public boolean hasPermissionToAccess(BaseAuth.AuthTok atok, boolean defaultResult, RepositoryHandle cfg) {
        return defaultResult;
    }

    @Override
    public int getAuthType() {
        return 6;
    }

    @Override
    public BaseAuth.AuthTok recreateAuth(String username) {
        try {
            long t0 = System.currentTimeMillis();
            SOAPPrincipal principal = SecurityServerClientFactory.getSecurityServerClient().findPrincipalByName(username);
            long t1 = System.currentTimeMillis();
            if (Logs.PERF_LOG.isDebugEnabled()) {
                Logs.PERF_LOG.debug((Object)("recreateAuth() in " + (t1 - t0) + "ms"));
            }
            return this.generateAuthToken(principal, null);
        }
        catch (ObjectNotFoundException e2) {
            this.appLog.warn((Object)"user not found", (Throwable)e2);
            return null;
        }
        catch (Exception e3) {
            this.appLog.warn((Object)"Problem communicating with Crowd", (Throwable)e3);
            return null;
        }
    }

    @Override
    public BaseAuth.AuthTok checkRequest(HttpServletRequest request, HttpServletResponse response) {
        if (!this.ssoEnabled) {
            return null;
        }
        try {
            long t0 = System.currentTimeMillis();
            if (!HttpAuthenticatorFactory.getHttpAuthenticator().isAuthenticated(request, response)) {
                long t1 = System.currentTimeMillis();
                if (Logs.PERF_LOG.isDebugEnabled()) {
                    Logs.PERF_LOG.debug((Object)("checkRequest() 1 in " + (t1 - t0) + "ms"));
                }
                return null;
            }
            SOAPPrincipal principal = HttpAuthenticatorFactory.getHttpAuthenticator().getPrincipal(request);
            long t1 = System.currentTimeMillis();
            if (Logs.PERF_LOG.isDebugEnabled()) {
                Logs.PERF_LOG.debug((Object)("checkRequest() 2 in " + (t1 - t0) + "ms"));
            }
            return this.generateAuthToken(principal, HttpAuthenticatorFactory.getHttpAuthenticator().getToken(request));
        }
        catch (Exception e2) {
            this.appLog.warn((Object)"Problem communicating with Crowd", (Throwable)e2);
            return null;
        }
    }

    @Override
    protected boolean isRequestUserStillValid(UserLogin user, BaseAuth.AuthTok authTok, HttpServletRequest request, HttpServletResponse response) {
        if (!this.ssoEnabled) {
            return true;
        }
        try {
            if (!HttpAuthenticatorFactory.getHttpAuthenticator().isAuthenticated(request, response)) {
                LoginCookie cookie = user.getCookie();
                if (cookie != null) {
                    int type = cookie.getType();
                    return type == 2;
                }
                return false;
            }
            if (!(authTok instanceof CrowdAuthTok)) {
                return false;
            }
            CrowdAuthTok token = (CrowdAuthTok)authTok;
            String currentToken = HttpAuthenticatorFactory.getHttpAuthenticator().getToken(request);
            if (StringUtil.equal(token.initialToken, currentToken)) {
                return true;
            }
            SOAPPrincipal principal = HttpAuthenticatorFactory.getHttpAuthenticator().getPrincipal(request);
            boolean sameUser = user.getUsername().equals(principal.getName());
            if (sameUser) {
                token.initialToken = currentToken;
                return true;
            }
            return false;
        }
        catch (Exception e2) {
            this.appLog.warn((Object)"Problem communicating with Crowd", (Throwable)e2);
            return false;
        }
    }

    private BaseAuth.AuthTok generateAuthToken(SOAPPrincipal principal, String initialToken) {
        return new CrowdAuthTok(principal, initialToken);
    }

    @Override
    public void logout(UserLogin login, HttpServletRequest request, HttpServletResponse response) {
        try {
            HttpAuthenticatorFactory.getHttpAuthenticator().logoff(request, response);
        }
        catch (Exception e2) {
            this.appLog.warn((Object)"Problem communicating with Crowd", (Throwable)e2);
        }
    }

    @Override
    public boolean supportsGroups() {
        return true;
    }

    @Override
    public List<String> listGroups() {
        try {
            long t0 = System.currentTimeMillis();
            List<String> result = Arrays.asList(SecurityServerClientFactory.getSecurityServerClient().findAllGroupNames());
            long t1 = System.currentTimeMillis();
            if (Logs.PERF_LOG.isDebugEnabled()) {
                Logs.PERF_LOG.debug((Object)("listGroups() in " + (t1 - t0) + "ms"));
            }
            return result;
        }
        catch (Exception e2) {
            this.appLog.warn((Object)"Problem communicating with Crowd", (Throwable)e2);
            return Collections.emptyList();
        }
    }

    @Override
    public List<String> getUsersInGroup(String group) {
        try {
            long t0 = System.currentTimeMillis();
            SOAPGroup g2 = SecurityServerClientFactory.getSecurityServerClient().findGroupByName(group);
            List<String> result = Arrays.asList(g2.getMembers());
            long t1 = System.currentTimeMillis();
            if (Logs.PERF_LOG.isDebugEnabled()) {
                Logs.PERF_LOG.debug((Object)("getUsersInGroup() in " + (t1 - t0) + "ms"));
            }
            return result;
        }
        catch (ObjectNotFoundException e2) {
            return Collections.emptyList();
        }
        catch (Exception e3) {
            this.appLog.warn((Object)"Problem communicating with Crowd", (Throwable)e3);
            return Collections.emptyList();
        }
    }

    @Override
    public boolean isUserInGroup(String group, String username) {
        try {
            long t0 = System.currentTimeMillis();
            boolean member = this.getGroupsForUser(username).contains(group);
            long t1 = System.currentTimeMillis();
            if (Logs.PERF_LOG.isDebugEnabled()) {
                Logs.PERF_LOG.debug((Object)("isUserInGroup() in " + (t1 - t0) + "ms"));
            }
            return member;
        }
        catch (Exception e2) {
            this.appLog.warn((Object)"Problem communicating with Crowd", (Throwable)e2);
            return false;
        }
    }

    @Override
    public List<String> getGroupsForUser(String username) {
        try {
            long t0 = System.currentTimeMillis();
            String[] groups = this.gcache.groupsForUser(username);
            if (groups == null) {
                groups = SecurityServerClientFactory.getSecurityServerClient().findGroupMemberships(username);
                this.gcache.updatesGroupsForUser(username, groups);
            }
            List<String> result = Arrays.asList(groups);
            long t1 = System.currentTimeMillis();
            if (Logs.PERF_LOG.isDebugEnabled()) {
                Logs.PERF_LOG.debug((Object)("getGroupsForUser() in " + (t1 - t0) + "ms"));
            }
            return result;
        }
        catch (Exception e2) {
            this.appLog.warn((Object)"Problem communicating with Crowd", (Throwable)e2);
            return Collections.emptyList();
        }
    }
}

