/*
 * Decompiled with CFR 0.152.
 */
package com.cenqua.fisheye.util;

import com.cenqua.fisheye.util.CompareUtil;
import com.cenqua.obfuscate.idbk4uide._Cu;
import java.io.Serializable;

public class MinMaxLongRange
implements Serializable {
    private long mMin;
    private long mMax;
    private boolean mIsSet = false;

    public MinMaxLongRange() {
    }

    public MinMaxLongRange(boolean isSet, long min, long max) {
        this.mMin = min;
        this.mMax = max;
        this.mIsSet = isSet;
    }

    public boolean add(long val) {
        if (this.mIsSet) {
            boolean updated = false;
            if (val < this.mMin) {
                this.mMin = val;
                updated = true;
            }
            if (val > this.mMax) {
                this.mMax = val;
                updated = true;
            }
            return updated;
        }
        this.mMin = val;
        this.mMax = val;
        this.mIsSet = true;
        return true;
    }

    public void add(MinMaxLongRange range) {
        if (!range.isSet()) {
            return;
        }
        this.add(range.getMin());
        this.add(range.getMax());
    }

    public long getMin() {
        return this.mMin;
    }

    public long getMax() {
        return this.mMax;
    }

    public boolean isSet() {
        return this.mIsSet;
    }

    public int compareMax(MinMaxLongRange rhs, boolean sortUnsetDown) {
        return MinMaxLongRange.compare(this.mMax, this.mIsSet, rhs.mMax, rhs.mIsSet, sortUnsetDown);
    }

    public int compareMin(MinMaxLongRange rhs, boolean sortUnsetDown) {
        return MinMaxLongRange.compare(this.mMin, this.mIsSet, rhs.mMin, rhs.mIsSet, sortUnsetDown);
    }

    public String toString() {
        if (this.mIsSet) {
            return "[" + this.mMin + "-" + this.mMax + "]";
        }
        return "[UnSet]";
    }

    private static int compare(long maxA, boolean isSetA, long maxB, boolean isSetB, boolean sortUnsetDown) {
        if (!isSetA && !isSetB) {
            return 0;
        }
        if (!isSetA) {
            return sortUnsetDown ? -1 : 1;
        }
        if (!isSetB) {
            return sortUnsetDown ? 1 : -1;
        }
        return CompareUtil.compareTo(maxA, maxB);
    }

    public void writeToCursor(_Cu cu) {
        cu.append(this.isSet());
        cu.append(this.getMin());
        cu.append(this.getMax());
    }

    public int readFromCursor(_Cu cu, int off) {
        this.mIsSet = cu.booleanAt(off);
        off = cu.skipBoolean(off);
        this.mMin = cu.longAt(off);
        off = cu.skipLong(off);
        this.mMax = cu.longAt(off);
        off = cu.skipLong(off);
        return off;
    }

    public void reset() {
        this.mIsSet = false;
    }
}

