/*
 * Decompiled with CFR 0.152.
 */
package com.cenqua.fisheye.vis;

import com.cenqua.fisheye.rep.Blame;
import com.cenqua.fisheye.vis.LegendValue;
import gnu.trove.TLongObjectHashMap;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AnnotationColourer {
    private int mChunkIndex;
    protected List<Blame.BlameChunk> mChunks;

    public abstract String getLineStyle(int var1, Blame.BlameChunk var2);

    public abstract int getLegendSize();

    public abstract String getLegendStyle(int var1);

    public abstract String getLegendName(int var1);

    public abstract long getLegendKey(int var1);

    public abstract int getLegendLOC(int var1);

    public abstract int getLegendStyleKey(int var1);

    protected abstract void process();

    protected abstract void processEmpty();

    public int getChunkIndex() {
        return this.mChunkIndex;
    }

    public void setChunkIndex(int chunkIndex) {
        this.mChunkIndex = chunkIndex;
    }

    public List<LegendValue> getLegend() {
        int len = this.getLegendSize();
        ArrayList<LegendValue> legend = new ArrayList<LegendValue>(len);
        for (int i2 = 0; i2 < len; ++i2) {
            String c2 = this.getLegendStyle(i2);
            String name = this.getLegendName(i2);
            int loc = this.getLegendLOC(i2);
            long key = this.getLegendKey(i2);
            legend.add(new LegendValue(key, name, c2, loc));
        }
        return legend;
    }

    public String getStyleClass() {
        Blame.BlameChunk chunk = this.getCurrentChunk();
        return this.getLineStyle(this.mChunkIndex, chunk);
    }

    private Blame.BlameChunk getCurrentChunk() {
        return this.mChunks.get(this.mChunkIndex);
    }

    static void addToListInMap(Map<String, List<Blame.BlameChunk>> chunkMap, String key, Blame.BlameChunk chunk) {
        List<Blame.BlameChunk> chunks;
        if (chunkMap.containsKey(key)) {
            chunks = chunkMap.get(key);
        } else {
            chunks = new ArrayList<Blame.BlameChunk>(1);
            chunkMap.put(key, chunks);
        }
        chunks.add(chunk);
    }

    static void addToChunkGroupInMap(Map<String, ChunkGroup> chunkMap, String key, Blame.BlameChunk chunk) {
        ChunkGroup chunks;
        if (chunkMap.containsKey(key)) {
            chunks = chunkMap.get(key);
        } else {
            chunks = new ChunkGroup();
            chunkMap.put(key, chunks);
        }
        chunks.addChunk(chunk);
    }

    static void addToChunkGroupInMap(TLongObjectHashMap chunkMap, long key, Blame.BlameChunk chunk) {
        ChunkGroup chunks;
        if (chunkMap.containsKey(key)) {
            chunks = (ChunkGroup)chunkMap.get(key);
        } else {
            chunks = new ChunkGroup();
            chunkMap.put(key, (Object)chunks);
        }
        chunks.addChunk(chunk);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static class ChunkGroup {
        private final List<Blame.BlameChunk> chunks = new ArrayList<Blame.BlameChunk>();
        private int chunkTotal = 0;

        ChunkGroup() {
        }

        public void addChunk(Blame.BlameChunk chunk) {
            this.chunks.add(chunk);
            this.chunkTotal += chunk.getLength();
        }

        public int getChunkTotal() {
            return this.chunkTotal;
        }

        public List<Blame.BlameChunk> getChunks() {
            return Collections.unmodifiableList(this.chunks);
        }

        public Blame.BlameChunk[] toArray() {
            return this.chunks.toArray(new Blame.BlameChunk[this.chunks.size()]);
        }
    }
}

