/*
 * Decompiled with CFR 0.152.
 */
package com.cenqua.fisheye.vis;

import com.cenqua.fisheye.rep.Blame;
import com.cenqua.fisheye.rep.FileRevision;
import com.cenqua.fisheye.util.CompareUtil;
import com.cenqua.fisheye.vis.AnnotationColourer;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;

class BlameColourer
extends AnnotationColourer {
    private List mAuthors;
    private AnnotationColourer.ChunkGroup[] mAuthorChunks;

    BlameColourer() {
    }

    protected void processEmpty() {
        this.mAuthors = new ArrayList(0);
        this.mAuthorChunks = new AnnotationColourer.ChunkGroup[0];
    }

    protected void process() {
        final HashMap<String, AnnotationColourer.ChunkGroup> auths = new HashMap<String, AnnotationColourer.ChunkGroup>();
        for (Blame.BlameChunk chunk : this.mChunks) {
            FileRevision info = chunk.getInfo();
            String author = info.getAuthor() != null ? info.getAuthor() : "other";
            BlameColourer.addToChunkGroupInMap(auths, author, chunk);
        }
        this.mAuthors = new ArrayList(auths.keySet());
        Collections.sort(this.mAuthors, new Comparator(){

            public int compare(Object o1, Object o2) {
                AnnotationColourer.ChunkGroup count1 = (AnnotationColourer.ChunkGroup)auths.get(o1);
                AnnotationColourer.ChunkGroup count2 = (AnnotationColourer.ChunkGroup)auths.get(o2);
                return CompareUtil.compareTo(count2.getChunkTotal(), count1.getChunkTotal());
            }
        });
        this.mAuthorChunks = new AnnotationColourer.ChunkGroup[auths.size()];
        for (int i2 = 0; i2 < this.mAuthorChunks.length; ++i2) {
            String author = (String)this.mAuthors.get(i2);
            this.mAuthorChunks[i2] = (AnnotationColourer.ChunkGroup)auths.get(author);
        }
    }

    public int getLegendSize() {
        return this.mAuthors.size();
    }

    public String getLegendStyle(int i2) {
        String auth = (String)this.mAuthors.get(i2);
        return "annotAuth" + this.authToStyle(auth);
    }

    public String getLegendName(int i2) {
        return (String)this.mAuthors.get(i2);
    }

    public long getLegendKey(int i2) {
        return i2;
    }

    public int getLegendLOC(int i2) {
        return this.mAuthorChunks[i2].getChunkTotal();
    }

    public int getLegendStyleKey(int i2) {
        return this.authToStyle((String)this.mAuthors.get(i2));
    }

    public String getLineStyle(int idx, Blame.BlameChunk chunk) {
        return "annotAuth" + this.authToStyle(chunk.getInfo().getAuthor());
    }

    private int authToStyle(String auth) {
        int idx = this.authPosition(auth);
        return idx % 256;
    }

    public int authPosition(String auth) {
        return this.mAuthors.indexOf(auth);
    }
}

