/*
 * Decompiled with CFR 0.152.
 */
package com.cenqua.fisheye.vis;

import com.cenqua.fisheye.rep.AncestorLink;
import com.cenqua.fisheye.rep.FileHistory;
import com.cenqua.fisheye.rep.FileRevision;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;

public class Graph {
    private final Set mFullBranchPoints = new HashSet();
    private final FileHistory mHistory;
    private final Set mFullBranchNames = new HashSet();
    private final Set mRootBranches = new HashSet();

    public Graph(FileHistory history) {
        this.mHistory = history;
    }

    public void visitSpudOrder(Visitor v) {
        this.visitSpudOrder(v, true);
    }

    public void visitSpudOrder(Visitor v, boolean branchTopToBottom) {
        HashSet visited = new HashSet();
        this.visitBranchesSpudOrder(this.mRootBranches, v, branchTopToBottom, visited);
    }

    private void visitBranchesSpudOrder(Collection rootBranches, Visitor v, boolean branchTopToBottom, Set visited) {
        for (String br : rootBranches) {
            List<String> branches;
            FileRevision info;
            String rev;
            int j;
            if (this.mHistory.getFirstRevisionOnBranch(br) == null || visited.contains(br)) continue;
            v.visitingBranch(br);
            visited.add(br);
            List revs = this.getBranch(br);
            if (branchTopToBottom) {
                for (j = 0; j < revs.size(); ++j) {
                    rev = (String)revs.get(j);
                    info = this.mHistory.getRevision(rev);
                    branches = info.getBranches();
                    if (branches == null || branches.isEmpty()) continue;
                    this.visitBranchesSpudOrder(branches, v, branchTopToBottom, visited);
                }
                continue;
            }
            for (j = revs.size() - 1; j >= 0; --j) {
                rev = (String)revs.get(j);
                info = this.mHistory.getRevision(rev);
                branches = info.getBranches();
                if (branches == null || branches.isEmpty()) continue;
                this.visitBranchesSpudOrder(branches, v, branchTopToBottom, visited);
            }
        }
    }

    public Collection getBranchNames() {
        return this.mFullBranchNames;
    }

    public List getBranch(String br) {
        List l = this.mHistory.getRevisions(br);
        Collections.reverse(l);
        return l;
    }

    public void collate() {
        for (FileRevision rev : this.mHistory.getRevisions()) {
            String br = rev.getBranch();
            this.mFullBranchNames.add(br);
            AncestorLink link = rev.getAncestorLink();
            if (link == null || !link.isDirect() && !link.isBranchPoint()) {
                this.mRootBranches.add(br);
            }
            String arev = rev.getAncestorRevision();
            boolean arevInHist = this.mHistory.containsRevision(arev);
            if (arev == null || !arevInHist) {
                this.mRootBranches.add(br);
            }
            if (link == null || !link.isBranchPoint() || arev == null || !arevInHist) continue;
            this.mFullBranchPoints.add(arev);
        }
    }

    public boolean isBranchPoint(String rev) {
        return this.mFullBranchPoints.contains(rev);
    }

    public String getBranchOf(String rev) {
        FileRevision info = this.mHistory.getRevision(rev);
        return info.getBranch();
    }

    public String getBranchPoint(String br) {
        return this.mHistory.getBranchPoint(br);
    }

    public static interface Visitor {
        public void visitingBranch(String var1);
    }
}

