/*
 * Decompiled with CFR 0.152.
 */
package com.cenqua.fisheye.vis;

import com.cenqua.fisheye.bucket.CalculatedBucketGraph;
import java.awt.Color;
import java.awt.Paint;
import java.awt.image.BufferedImage;
import java.io.IOException;
import java.io.OutputStream;
import org.jfree.chart.ChartRenderingInfo;
import org.jfree.chart.ChartUtilities;
import org.jfree.chart.JFreeChart;

public class LineCountChartUtils {
    static final Color GRIDLINES = Color.LIGHT_GRAY;
    static final Color AXIS_LABELS = Color.GRAY;
    private static final Color TOPLINE_DARK = new Color(12, 135, 201);
    private static final Color TOPLINE_LIGHT = new Color(230, 242, 250);
    private static final Color[] LINE_COLOURS_PIE = new Color[]{new Color(71, 142, 199), new Color(118, 152, 16), new Color(216, 86, 31), new Color(215, 229, 46), new Color(12, 67, 131), new Color(95, 190, 65), new Color(245, 131, 43), new Color(237, 239, 0), new Color(12, 135, 201), new Color(173, 42, 21)};
    private static final Color[] LINE_COLOURS_XY = new Color[]{new Color(215, 86, 31), new Color(71, 142, 199), new Color(118, 152, 16), new Color(222, 228, 57), new Color(95, 190, 65), new Color(12, 67, 131), new Color(245, 131, 43), new Color(237, 239, 0), new Color(12, 135, 201), new Color(173, 42, 21), new Color(230, 242, 250), new Color(174, 191, 71)};

    public static String getImageContentType() {
        return "image/png";
    }

    static Paint getXYColour(int i2) {
        return LINE_COLOURS_XY[i2 % LINE_COLOURS_XY.length];
    }

    static Paint getToplineColourDark() {
        return TOPLINE_DARK;
    }

    static Paint getToplineColourLight() {
        return TOPLINE_LIGHT;
    }

    static Paint getPieColour(int i2) {
        return LINE_COLOURS_PIE[i2 % LINE_COLOURS_PIE.length];
    }

    static BufferedImage renderAndWriteChart(JFreeChart chart, CalculatedBucketGraph graphs, OutputStream out, int w, int h2) throws IOException {
        BufferedImage image = LineCountChartUtils.renderChart(chart, graphs, w, h2);
        if (out != null) {
            ChartUtilities.writeBufferedImageAsPNG((OutputStream)out, (BufferedImage)image);
        }
        return image;
    }

    static BufferedImage renderChart(JFreeChart chart, CalculatedBucketGraph graphs, int w, int h2) {
        ChartRenderingInfo info = new ChartRenderingInfo();
        BufferedImage image = chart.createBufferedImage(w, h2, info);
        graphs.setChartRenderingInfo(info);
        return image;
    }
}

