/*
 * Decompiled with CFR 0.152.
 */
package com.cenqua.fisheye.vis;

import gnu.trove.TLongArrayList;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import org.jfree.data.xy.XYSeries;

public class LinecountCollator {
    private final int MAX_HOLD_SIZE;
    private final IrregularData mIrregular;
    private RegularData mRegular;

    private LinecountCollator(int maxHoldSize, IrregularData irregular, RegularData regular) {
        this.MAX_HOLD_SIZE = maxHoldSize;
        this.mIrregular = irregular;
        this.mRegular = regular;
    }

    public LinecountCollator() {
        this(150, 300);
    }

    public LinecountCollator(int maxIrregularSize, int maxRegularSize) {
        this.MAX_HOLD_SIZE = maxRegularSize;
        this.mIrregular = new IrregularData(maxIrregularSize);
    }

    public void addDatapoint(long t0, long t1, long linecount, long inc) {
        this.addDatapoint(t0, linecount, inc);
        if (t1 != Long.MAX_VALUE) {
            this.addDatapoint(t1, -linecount, 0L);
        }
    }

    public void updateEndPoint(long t1, long linecount) {
        this.addDatapoint(t1, -linecount, 0L);
    }

    private void addDatapoint(long date, long change, long inc) {
        if (this.mRegular != null && this.mRegular.withinDomain(date)) {
            this.mRegular.addDatapoint(date, change, inc);
            return;
        }
        if (this.mIrregular.isFull()) {
            this.flushToRegular();
        }
        if (this.mRegular != null && this.mRegular.withinDomain(date)) {
            this.mRegular.addDatapoint(date, change, inc);
        } else {
            this.mIrregular.addDatapoint(date, change, inc);
        }
    }

    private void flushToRegular() {
        if (this.mRegular == null) {
            this.mRegular = new RegularData(this.MAX_HOLD_SIZE, this.mIrregular);
            this.mIrregular.clear();
        } else if (!this.mIrregular.isEmpty()) {
            this.mRegular.copyFrom(this.mIrregular);
            this.mIrregular.clear();
        }
    }

    public void addToDataSeries(XYSeries series) {
        if (this.mRegular == null) {
            this.mIrregular.addToDataSeries(series);
        } else {
            this.flushToRegular();
            this.mRegular.addToDataSeries(series);
        }
    }

    public XYSeries createLineCountSeries(String name) {
        XYSeries series = new XYSeries((Comparable)((Object)name), true, true);
        if (this.mRegular == null) {
            this.mIrregular.addToDataSeries(series);
        } else {
            this.flushToRegular();
            this.mRegular.addToDataSeries(series);
        }
        return series;
    }

    public XYSeries createCommitVolumeSeries(String name) {
        XYSeries series = new XYSeries((Comparable)((Object)name));
        if (this.mRegular == null) {
            this.mIrregular.addCountToDataSeries(series);
        } else {
            this.flushToRegular();
            this.mRegular.addCountToDataSeries(series);
        }
        return series;
    }

    public long getMaxDomain() {
        if (this.mIrregular != null && this.mRegular != null) {
            return Math.max(this.mIrregular.getMaxDate(), this.mRegular.mMaxRegularDate);
        }
        if (this.mIrregular != null) {
            return this.mIrregular.getMaxDate();
        }
        return this.mRegular.mMaxRegularDate;
    }

    public void toStream(DataOutputStream out) throws IOException {
        out.writeInt(this.MAX_HOLD_SIZE);
        out.writeInt(this.mIrregular.mSize);
        if (this.mRegular == null) {
            out.writeChar(73);
            this.mIrregular.toStream(out);
        } else {
            this.flushToRegular();
            out.writeChar(82);
            this.mRegular.toStream(out);
        }
    }

    public static LinecountCollator fromStream(DataInputStream in) throws IOException {
        int maxHoldSize = in.readInt();
        int maxIrregularSize = in.readInt();
        char type = in.readChar();
        if (type == 'I') {
            IrregularData data = IrregularData.fromStream(in);
            return new LinecountCollator(maxHoldSize, data, null);
        }
        RegularData data = RegularData.fromStream(in);
        return new LinecountCollator(maxHoldSize, new IrregularData(maxIrregularSize), data);
    }

    private static TLongArrayList readArray(DataInputStream in) throws IOException {
        int length = in.readInt();
        TLongArrayList array = new TLongArrayList(length);
        for (int i2 = 0; i2 < length; ++i2) {
            array.add(in.readLong());
        }
        return array;
    }

    private static void writeArray(DataOutputStream out, TLongArrayList longs) throws IOException {
        out.writeInt(longs.size());
        for (int i2 = 0; i2 < longs.size(); ++i2) {
            long aLong = longs.get(i2);
            out.writeLong(aLong);
        }
    }

    private static class RegularData {
        private TLongArrayList mRange;
        private TLongArrayList mRangeCount;
        private long mMinRegularDate;
        private long mMaxRegularDate;
        private final int mSize;
        private static final int TOKEN = 82;

        private RegularData(TLongArrayList range, TLongArrayList rangeCount, long minRegularDate, long maxRegularDate, int size) {
            this.mRange = range;
            this.mRangeCount = rangeCount;
            this.mMinRegularDate = minRegularDate;
            this.mMaxRegularDate = maxRegularDate;
            this.mSize = size;
        }

        public RegularData(int size, IrregularData initialData) {
            assert (!initialData.isEmpty());
            this.mSize = size;
            this.mRange = new TLongArrayList(size);
            this.mRangeCount = new TLongArrayList(size);
            this.mRange.fill(0, this.mSize, 0L);
            this.mRangeCount.fill(0, this.mSize, 0L);
            this.mMinRegularDate = initialData.getMinDate();
            this.mMaxRegularDate = initialData.getMaxDate();
            this.copyFrom(initialData);
        }

        public boolean withinDomain(long date) {
            return this.mMinRegularDate <= date && date <= this.mMaxRegularDate;
        }

        public void addDatapoint(long date, long change, long inc) {
            int idx = (int)((date - this.mMinRegularDate) * (long)this.mSize / (this.mMaxRegularDate - this.mMinRegularDate));
            idx = Math.max(idx, 0);
            idx = Math.min(idx, this.mSize - 1);
            this.mRange.set(idx, this.mRange.get(idx) + change);
            this.mRangeCount.set(idx, this.mRangeCount.get(idx) + inc);
        }

        public void copyFrom(IrregularData data) {
            assert (!data.isEmpty());
            if (!this.withinDomain(data.getMinDate()) || !this.withinDomain(data.getMaxDate())) {
                TLongArrayList oldRange = this.mRange;
                TLongArrayList oldRangeCount = this.mRangeCount;
                long oldMin = this.mMinRegularDate;
                long oldMax = this.mMaxRegularDate;
                this.mRange = new TLongArrayList(this.mSize);
                this.mRangeCount = new TLongArrayList(this.mSize);
                this.mRange.fill(0, this.mSize, 0L);
                this.mRangeCount.fill(0, this.mSize, 0L);
                this.mMinRegularDate = Math.min(oldMin, data.getMinDate());
                this.mMaxRegularDate = Math.max(oldMax, data.getMaxDate());
                for (int i2 = 0; i2 < oldRange.size(); ++i2) {
                    long date = oldMin + (long)i2 * (oldMax - oldMin) / (long)oldRange.size();
                    long change = oldRange.get(i2);
                    long inc = oldRangeCount.get(i2);
                    this.addDatapoint(date, change, inc);
                }
            }
            TLongArrayList domain = data.mDomain;
            TLongArrayList range = data.mRange;
            TLongArrayList rangeCount = data.mRangeCount;
            for (int i3 = 0; i3 < domain.size(); ++i3) {
                long date = domain.get(i3);
                long change = range.get(i3);
                long inc = rangeCount.get(i3);
                this.addDatapoint(date, change, inc);
            }
        }

        public void addToDataSeries(XYSeries ds) {
            long change = 0L;
            for (int i2 = 0; i2 < this.mRange.size(); ++i2) {
                long date = this.mMinRegularDate + (long)i2 * (this.mMaxRegularDate - this.mMinRegularDate) / (long)this.mRange.size();
                long c2 = this.mRange.get(i2);
                if (c2 == 0L) continue;
                ds.add((double)date, (double)(change += c2));
            }
        }

        public void addCountToDataSeries(XYSeries ds) {
            for (int i2 = 0; i2 < this.mRange.size(); ++i2) {
                long date = this.mMinRegularDate + (long)i2 * (this.mMaxRegularDate - this.mMinRegularDate) / (long)this.mRangeCount.size();
                long c2 = this.mRangeCount.get(i2);
                if (c2 == 0L) continue;
                ds.add((double)date, (double)c2);
            }
        }

        private void toStream(DataOutputStream out) throws IOException {
            LinecountCollator.writeArray(out, this.mRange);
            LinecountCollator.writeArray(out, this.mRangeCount);
            out.writeLong(this.mMaxRegularDate);
            out.writeLong(this.mMinRegularDate);
            out.writeInt(this.mSize);
        }

        private static RegularData fromStream(DataInputStream in) throws IOException {
            TLongArrayList range = LinecountCollator.readArray(in);
            TLongArrayList rangeCount = LinecountCollator.readArray(in);
            long maxRegularDate = in.readLong();
            long minRegularDate = in.readLong();
            int size = in.readInt();
            return new RegularData(range, rangeCount, minRegularDate, maxRegularDate, size);
        }
    }

    private static class IrregularData {
        private final TLongArrayList mDomain;
        private final TLongArrayList mRange;
        private final TLongArrayList mRangeCount;
        private final int mSize;
        private static final int TOKEN = 73;

        private IrregularData(TLongArrayList domain, TLongArrayList range, TLongArrayList rangeCount, int size) {
            this.mDomain = domain;
            this.mRange = range;
            this.mRangeCount = rangeCount;
            this.mSize = size;
        }

        public IrregularData(int size) {
            this.mSize = size;
            this.mDomain = new TLongArrayList(size);
            this.mRange = new TLongArrayList(size);
            this.mRangeCount = new TLongArrayList(size);
        }

        public boolean isFull() {
            return this.mSize == this.mDomain.size();
        }

        public boolean isEmpty() {
            return this.mDomain.isEmpty();
        }

        public long getMinDate() {
            return this.mDomain.get(0);
        }

        public long getMaxDate() {
            return this.mDomain.size() > 0 ? this.mDomain.get(this.mDomain.size() - 1) : 0L;
        }

        public void addDatapoint(long date, long change, long inc) {
            int idx = this.mDomain.binarySearch(date);
            if (idx >= 0) {
                this.mRange.set(idx, this.mRange.get(idx) + change);
                this.mRangeCount.set(idx, this.mRangeCount.get(idx) + inc);
            } else if ((idx = -idx) > this.mDomain.size()) {
                this.mDomain.add(date);
                this.mRange.add(change);
                this.mRangeCount.add(inc);
            } else {
                this.mDomain.insert(--idx, date);
                this.mRange.insert(idx, change);
                this.mRangeCount.insert(idx, inc);
            }
        }

        public void clear() {
            this.mDomain.clear();
            this.mRange.clear();
            this.mRangeCount.clear();
        }

        public void addToDataSeries(XYSeries ds) {
            long change = 0L;
            for (int i2 = 0; i2 < this.mDomain.size(); ++i2) {
                long date = this.mDomain.get(i2);
                ds.add((double)date, (double)(change += this.mRange.get(i2)));
            }
        }

        public void addCountToDataSeries(XYSeries ds) {
            for (int i2 = 0; i2 < this.mDomain.size(); ++i2) {
                ds.add((double)this.mDomain.get(i2), (double)this.mRangeCount.get(i2));
            }
        }

        private void toStream(DataOutputStream out) throws IOException {
            LinecountCollator.writeArray(out, this.mDomain);
            LinecountCollator.writeArray(out, this.mRange);
            LinecountCollator.writeArray(out, this.mRangeCount);
            out.writeInt(this.mSize);
        }

        private static IrregularData fromStream(DataInputStream in) throws IOException {
            TLongArrayList domain = LinecountCollator.readArray(in);
            TLongArrayList range = LinecountCollator.readArray(in);
            TLongArrayList rangeCount = LinecountCollator.readArray(in);
            int size = in.readInt();
            return new IrregularData(domain, range, rangeCount, size);
        }
    }
}

