/*
 * Decompiled with CFR 0.152.
 */
package com.cenqua.fisheye.web;

import com.cenqua.fisheye.util.MultiMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.StringTokenizer;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CommandString {
    private String commandWord;
    private MultiMap<String, String> commandParams;

    public CommandString(String cmdStr) {
        StringTokenizer tok = new StringTokenizer(cmdStr, ",", false);
        if (tok.hasMoreTokens()) {
            this.parseCommandComponent(tok.nextToken(), true);
            while (tok.hasMoreTokens()) {
                String str = tok.nextToken();
                this.parseCommandComponent(str, false);
            }
        }
    }

    public CommandString(String commandWord, MultiMap<String, String> commandParams) {
        this.commandWord = commandWord;
        this.commandParams = commandParams;
    }

    public String getCommandWord() {
        return this.commandWord;
    }

    public String getCommandParam(String key) {
        if (this.commandParams == null) {
            return null;
        }
        return this.commandParams.getFirst(key);
    }

    public List<String> getCommandParams(String key) {
        if (this.commandParams == null) {
            return null;
        }
        return this.commandParams.getList(key);
    }

    public String toString() {
        StringBuffer buf = new StringBuffer();
        if (this.commandWord != null) {
            buf.append(this.commandWord);
        }
        if (this.commandParams != null && this.commandParams.size() > 0) {
            if (this.commandWord != null) {
                buf.append(",");
            }
            String sep = "";
            for (String key : this.commandParams.keySet()) {
                List<String> vals = this.commandParams.getList(key);
                for (String val : vals) {
                    buf.append(sep).append(key).append("=").append(val);
                    sep = ",";
                }
            }
        }
        return buf.toString();
    }

    private void parseCommandComponent(String str, boolean isFirst) {
        if (str.length() == 0) {
            return;
        }
        int i2 = str.indexOf(61);
        if (i2 != -1) {
            String key = str.substring(0, i2);
            String value = str.substring(i2 + 1, str.length());
            this.addCommandParam(key, value);
        } else if (isFirst) {
            this.commandWord = str;
        } else {
            this.addCommandParam(str, str);
        }
    }

    private void addCommandParam(String key, String value) {
        if (this.commandParams == null) {
            this.commandParams = new MultiMap(new LinkedHashMap());
        }
        this.commandParams.add(key, value);
    }
}

