/*
 * Decompiled with CFR 0.152.
 */
package com.cenqua.fisheye.web;

import com.cenqua.fisheye.Path;
import com.cenqua.fisheye.RepositoryConfig;
import com.cenqua.fisheye.bucket.BucketGraph;
import com.cenqua.fisheye.bucket.CalculatedBucketGraph;
import com.cenqua.fisheye.bucket.CalculatedBucketGraphXY;
import com.cenqua.fisheye.bucket.ParameterSetRetrieve;
import com.cenqua.fisheye.cache.RevisionCache;
import com.cenqua.fisheye.logging.Logs;
import com.cenqua.fisheye.rep.DbException;
import com.cenqua.fisheye.rep.RepositoryEngine;
import com.cenqua.fisheye.util.Timer;
import com.cenqua.fisheye.vis.LineCountChart;
import com.cenqua.fisheye.vis.LineCountChartLine;
import com.cenqua.fisheye.vis.LineCountChartUtils;
import com.cenqua.fisheye.web.BaseAction;
import com.cenqua.fisheye.web.DirTreeFragmentAction;
import com.cenqua.fisheye.web.FishEyePathInfo;
import com.cenqua.fisheye.web.RepositoryExplorer;
import com.cenqua.fisheye.web.ViewFileAction;
import com.cenqua.fisheye.web.tarball.TarballAction;
import com.cenqua.fisheye.web.util.ParamUtils;
import java.awt.Dimension;
import java.awt.image.BufferedImage;
import java.io.IOException;
import java.io.OutputStream;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.jfree.chart.ChartRenderingInfo;
import org.jfree.chart.ChartUtilities;
import org.jfree.chart.imagemap.ImageMapUtilities;

public class ViewRepositoryServlet
extends BaseAction {
    private RepositoryEngine engine;

    public void setup() {
        this.engine = this.getPathInfo().getEngine();
    }

    public long computeLastModified() throws DbException {
        return this.computeRepositoryLastModified();
    }

    public BaseAction handleRequest() throws ServletException, IOException, DbException {
        FishEyePathInfo pi = this.getPathInfo();
        Path lPath = pi.getLocalPath();
        HttpServletRequest req = this.getRequest();
        if (req.getParameter("dirtreefragrender") != null) {
            return new DirTreeFragmentAction("browse");
        }
        if (this.handleWaybackJump("/browse")) {
            return null;
        }
        this.parseWaybackSpec();
        RevisionCache rep = this.engine.getRevisionCache();
        if (this.handleWatches("/browse")) {
            return null;
        }
        if (pi.getCommandParam("tarball") != null) {
            return new TarballAction();
        }
        if (rep.isDir(lPath)) {
            return this.handleDirRequest();
        }
        if (rep.isFile(lPath)) {
            return new ViewFileAction();
        }
        this.send404("Don't know how to handle path " + lPath);
        return null;
    }

    private BaseAction handleDirRequest() throws IOException, ServletException, DbException {
        long t0 = System.currentTimeMillis();
        FishEyePathInfo pi = this.getPathInfo();
        HttpServletRequest req = this.getRequest();
        HttpServletResponse resp = this.getResponse();
        RepositoryConfig cfg = pi.getRepository();
        Path fpath = pi.getFullPath();
        Path lpath = pi.getLocalPath();
        if (req.getParameter("linegraph") != null) {
            this.doLineGraph(req, resp, lpath);
        } else if (req.getParameter("imageMap") != null) {
            this.doImageMap(lpath, req, resp);
        } else {
            req.setAttribute("path", (Object)lpath);
            req.setAttribute("fpath", (Object)fpath);
            req.setAttribute("tarballNamePrefix", (Object)TarballAction.makeTarballFilename(fpath));
            req.setAttribute("repository", (Object)new RepositoryExplorer(this.engine, lpath, this.mWB, this.getUserPreferences()));
            boolean tarballEnabled = cfg.getTarballConfig().isEnabled() && !cfg.getTarballConfig().isExcluded(lpath);
            req.setAttribute("tarballEnabled", (Object)tarballEnabled);
            req.setAttribute("requiresAuth", (Object)this.requiresAuth());
            if (this.handleWatches("/browse")) {
                return null;
            }
            this.setupWaybackDropdowns();
            long t1 = System.currentTimeMillis();
            req.getRequestDispatcher("/WEB-INF/jsp/dirlist.jsp").forward((ServletRequest)req, (ServletResponse)resp);
            long t2 = System.currentTimeMillis();
            if (Logs.PERF_LOG.isDebugEnabled()) {
                Logs.PERF_LOG.debug((Object)("handleDirRequest-page for /" + lpath + " in " + (t1 - t0) + "ms then " + (t2 - t1) + "ms for render"));
            }
        }
        return null;
    }

    private void doLineGraph(HttpServletRequest req, HttpServletResponse resp, Path lpath) throws DbException, IOException {
        resp.setContentType(LineCountChartUtils.getImageContentType());
        Dimension d2 = ParamUtils.getDimension(req, 300, 220);
        Timer t = new Timer("'" + this.getRequest().getRequestURI() + "' doLineGraph:");
        this.renderLineGraph(true, d2, lpath);
        t.end();
    }

    private void doImageMap(Path lpath, HttpServletRequest req, HttpServletResponse resp) throws DbException, IOException {
        Logs.APP_LOG.debug((Object)(req.getRequestURI() + "?" + req.getQueryString()));
        Dimension d2 = ParamUtils.getDimension(req, 300, 220);
        String name = req.getParameter("imageMap");
        CalculatedBucketGraph graphs = this.renderLineGraph(false, d2, lpath);
        if (!graphs.noGraphData()) {
            String imageMap = ImageMapUtilities.getImageMap((String)name, (ChartRenderingInfo)graphs.getChartRenderingInfo());
            resp.getOutputStream().write(imageMap.getBytes());
        }
        resp.getOutputStream().flush();
    }

    private CalculatedBucketGraph renderLineGraph(Boolean writeImage, Dimension d2, Path lpath) throws DbException, IOException {
        String reqAuthor;
        String br = this.getBranchConstraint(lpath);
        String extn = "__ALL_EXTENSIONS__";
        String author = "__ALL_AUTHORS__";
        if (this.engine.getRevisionCache().showAuthorLinecount() && this.mWB != null && (reqAuthor = this.mWB.getAuthor()) != null && !reqAuthor.equals("")) {
            author = reqAuthor;
        }
        BucketGraph bucketGraph = this.engine.getBucketGraph();
        CalculatedBucketGraphXY graphs = bucketGraph.getXYSeries(new ParameterSetRetrieve(lpath, br, extn, author, bucketGraph.isCaseSensitive()), d2.width);
        BufferedImage image = new LineCountChartLine().renderPathHistoryImage(graphs, d2.width, d2.height, null, LineCountChart.getGraphTimeZone(this.getRequest()), true);
        if (writeImage.booleanValue()) {
            ChartUtilities.writeBufferedImageAsPNG((OutputStream)this.getResponse().getOutputStream(), (BufferedImage)image);
        }
        return graphs;
    }
}

