/*
 * Decompiled with CFR 0.152.
 */
package com.cenqua.fisheye.web;

import com.cenqua.fisheye.AppConfig;
import com.cenqua.fisheye.Path;
import com.cenqua.fisheye.cache.RevisionCache;
import com.cenqua.fisheye.cvsrep.search.SearchResults;
import com.cenqua.fisheye.cvsrep.search.query.AndClause;
import com.cenqua.fisheye.cvsrep.search.query.Clause;
import com.cenqua.fisheye.cvsrep.search.query.DateRangeClause;
import com.cenqua.fisheye.cvsrep.search.query.FishQuery;
import com.cenqua.fisheye.cvsrep.search.query.PathClause;
import com.cenqua.fisheye.cvsrep.search.query.Query3Clause;
import com.cenqua.fisheye.infinitydb.InfinityDbHandle;
import com.cenqua.fisheye.infinitydb.query3.EntityRangeQuery3;
import com.cenqua.fisheye.logging.Logs;
import com.cenqua.fisheye.mail.MailMessage;
import com.cenqua.fisheye.mail.Mailer;
import com.cenqua.fisheye.rep.ChangeSet;
import com.cenqua.fisheye.rep.DbException;
import com.cenqua.fisheye.rep.FileRevision;
import com.cenqua.fisheye.rep.RepositoryEngine;
import com.cenqua.fisheye.rep.RepositoryHandle;
import com.cenqua.fisheye.rep.RevInfoKey;
import com.cenqua.fisheye.rep.impl.CommonSchema;
import com.cenqua.fisheye.user.FEUser;
import com.cenqua.fisheye.user.UserLogin;
import com.cenqua.fisheye.user.UserManager;
import com.cenqua.fisheye.util.DateHelper;
import com.cenqua.fisheye.util.Disposer;
import com.cenqua.fisheye.util.StringUtil;
import com.cenqua.fisheye.web.UserProfile;
import com.cenqua.fisheye.web.UserProfileManager;
import com.cenqua.fisheye.web.Watch;
import com.cenqua.fisheye.web.WatchEAV;
import com.cenqua.fisheye.web.WaybackSpec;
import com.cenqua.fisheye.web.util.CheckinCommentFormatter;
import com.cenqua.fisheye.web.util.FishEyeURLEncoder;
import com.cenqua.obfuscate.idbk4uide._Cu;
import freemarker.ext.beans.BeansWrapper;
import freemarker.template.Template;
import freemarker.template.TemplateException;
import freemarker.template.TemplateHashModel;
import java.io.IOException;
import java.io.StringWriter;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.ListIterator;
import java.util.Set;
import java.util.Timer;
import java.util.TimerTask;

public class WatchManager {
    private final InfinityDbHandle db;
    private final Object dbLock;
    private final WatchChecker watchChecker;
    private final Timer dailyWatchCheckTrigger;
    private boolean stopped = false;
    private boolean debug;
    private static long ONE_DAY_MILLIS = 86400000L;

    private List checkWatch(Watch watch, RepositoryEngine rep) throws DbException {
        if (this.debug) {
            Logs.APP_LOG.debug((Object)("checking watch " + watch));
        }
        ArrayList<ChangeSet> changesets = new ArrayList<ChangeSet>();
        RevisionCache revCache = rep.getRevisionCache();
        long checked = System.currentTimeMillis();
        long revLastMod = revCache.getLastModifiedDate();
        long currentCSN = revCache.getCacheSerialNumber();
        if (this.debug) {
            Logs.APP_LOG.debug((Object)("revLastMod = " + revLastMod));
            Logs.APP_LOG.debug((Object)("currentCSN = " + currentCSN));
            Logs.APP_LOG.debug((Object)("checked = " + checked));
        }
        if (revLastMod > watch.getLastChecked()) {
            AndClause and;
            FishQuery query = new FishQuery();
            Path path = watch.getPath();
            if (revCache.isDir(path)) {
                query.setFromPath(path);
            } else {
                query.setFromPath(path.getParent());
            }
            query.setGroupBy(4);
            Clause where = null;
            RevInfoKey lastRevisionSent = watch.getLastRevisionSent();
            int lastRevid = -1;
            if (lastRevisionSent != null) {
                long lastCSN = watch.getCacheSerialOfLastRevisionSent();
                if (lastCSN != currentCSN) {
                    Logs.APP_LOG.debug((Object)"CSN changed, skipping lastRevisionSent");
                } else {
                    FileRevision rev = revCache.getFileRevision(lastRevisionSent);
                    if (rev != null) {
                        lastRevid = rev.getRevID();
                        where = WatchManager.revidClauseAfter(lastRevid);
                    }
                }
            }
            if (where == null) {
                where = WatchManager.dateRangeClauseFrom(watch.getLastChecked());
            }
            if (watch.getConstraint() != null) {
                and = new AndClause();
                and.addClause(where);
                and.addClause(watch.getConstraint().getEyeQLWhereClause(false));
                where = and;
            }
            if (revCache.isFile(path)) {
                and = new AndClause();
                and.addClause(where);
                and.addClause(new PathClause(path.toString(), false));
                where = and;
            }
            query.setWhereClause(where);
            query.setOrderBy(FishQuery.ORDER_BY_TYPE.DATE);
            if (this.debug) {
                Logs.APP_LOG.debug((Object)("query is " + query.makeQueryString()));
            }
            try {
                SearchResults collator = rep.getSearchManager().runQuery(query, true);
                if (this.debug) {
                    Logs.APP_LOG.debug((Object)("query returned " + collator.getPostTruncateSize() + " items."));
                }
                if (collator.getPostTruncateSize() > 0) {
                    SearchResults.RevisionResultsIterator it = collator.iterateRevisions(0);
                    while (it.hasNext()) {
                        FileRevision fr = it.nextItem();
                        if (this.debug) {
                            Logs.APP_LOG.debug((Object)("matched revid " + fr.getRevID() + " isStartOfGroup " + it.isStartOfGroup() + " " + it.currentGroup()));
                        }
                        if (fr.getRevID() > lastRevid) {
                            lastRevid = fr.getRevID();
                            lastRevisionSent = fr.getRevInfoKey();
                        }
                        if (!it.isStartOfGroup()) continue;
                        String csid = (String)it.currentGroup();
                        ChangeSet cs = revCache.getChangeSet(csid);
                        changesets.add(cs);
                    }
                    watch.setLastRevisionSent(lastRevisionSent);
                    watch.setCacheSerialOfLastRevisionSent(currentCSN);
                }
            }
            catch (DbException e2) {
                Logs.APP_LOG.error((Object)"Exception processing watch search results", (Throwable)e2);
            }
            catch (Exception e3) {
                Logs.APP_LOG.error((Object)"Exception running watch search", (Throwable)e3);
            }
        }
        watch.setLastChecked(checked);
        if (this.debug) {
            Logs.APP_LOG.debug((Object)("updating watch " + watch));
        }
        this.updateWatch(watch);
        return changesets;
    }

    private static Clause revidClauseAfter(int revid) {
        _Cu start = _Cu.alloc().append(revid).appendInfinity();
        _Cu end = null;
        EntityRangeQuery3 q = new EntityRangeQuery3(CommonSchema.RevInfo.ENTITY, start, end);
        return new Query3Clause(q);
    }

    private static DateRangeClause dateRangeClauseFrom(long d2) {
        DateRangeClause clause = new DateRangeClause();
        clause.setMin(d2);
        clause.setMinInclusive(true);
        return clause;
    }

    private void sendEmailForChangesets(UserProfile profile, RepositoryEngine rep, String watchpath, List changesets, boolean individual) {
        try {
            String contentType;
            String format;
            FEUser feuser = AppConfig.getsConfig().getUserManager().getUser(profile.getUsername());
            if (feuser == null || feuser.getEmail() == null) {
                Logs.APP_LOG.debug((Object)("Not sending watch mail to " + profile.getUsername() + ": no email address set."));
                return;
            }
            if (profile.getEmailFormat() == 1) {
                format = "html";
                contentType = "text/html; charset=UTF-8";
            } else {
                format = "plain";
                contentType = "text/plain; charset=UTF-8";
            }
            String template = "changeset-mail-" + format + ".ftl";
            Template csTmpl = AppConfig.getsConfig().getTemplateConfig().getTemplate(template);
            BeansWrapper wrapper = BeansWrapper.getDefaultInstance();
            TemplateHashModel commentFormatter = (TemplateHashModel)wrapper.getStaticModels().get(CheckinCommentFormatter.class.getName());
            TemplateHashModel urlEncoder = (TemplateHashModel)wrapper.getStaticModels().get(FishEyeURLEncoder.class.getName());
            TemplateHashModel stringUtil = (TemplateHashModel)wrapper.getStaticModels().get(StringUtil.class.getName());
            HashMap<String, Object> root = new HashMap<String, Object>();
            root.put("repname", rep.getName());
            root.put("repcfg", rep.getCfg());
            root.put("commentFormatter", commentFormatter);
            root.put("urlEncoder", urlEncoder);
            root.put("stringUtil", stringUtil);
            root.put("siteurl", AppConfig.getsConfig().getSiteURL());
            root.put("timezone", profile.getEffectiveTimezone());
            root.put("watchpath", watchpath);
            root.put("appnametag", AppConfig.getProductName());
            if (individual) {
                for (ChangeSet cs : changesets) {
                    ArrayList<ChangeSet> oneCs = new ArrayList<ChangeSet>();
                    oneCs.add(cs);
                    root.put("changesets", oneCs);
                    root.put("size", 1);
                    StringWriter msg = new StringWriter();
                    csTmpl.process(root, (Writer)msg);
                    msg.flush();
                    this.sendWatchEmail(contentType, feuser.getEmail(), "[" + AppConfig.getProductName() + "] " + rep.getName() + ":/" + watchpath + " " + cs.getId() + " by " + cs.getAuthor() + ": " + CheckinCommentFormatter.format(rep.getCfg(), cs.getComment(), 80, false, false), msg.toString());
                }
            } else {
                root.put("changesets", changesets);
                root.put("size", changesets.size());
                StringWriter msg = new StringWriter();
                csTmpl.process(root, (Writer)msg);
                msg.flush();
                this.sendWatchEmail(contentType, feuser.getEmail(), "[" + AppConfig.getProductName() + "] " + rep.getName() + ":/" + watchpath + " " + changesets.size() + " change" + (changesets.size() != 1 ? "s" : ""), msg.toString());
            }
        }
        catch (DbException e2) {
            Logs.APP_LOG.error((Object)("Exception loading info for user '" + profile.getUsername() + "'"), (Throwable)e2);
        }
        catch (IOException e3) {
            Logs.APP_LOG.error((Object)"Exception processing watch email template", (Throwable)e3);
        }
        catch (TemplateException e4) {
            Logs.APP_LOG.error((Object)"Exception processing watch email template", (Throwable)e4);
        }
    }

    private void sendWatchEmail(String contentType, String email, String subject, String body) {
        MailMessage msg = new MailMessage();
        msg.addRecipient(email);
        msg.setSubject(subject);
        msg.setBodyText(contentType, body);
        Mailer mailer = AppConfig.getsConfig().getMailer();
        mailer.sendMessage(msg);
    }

    public WatchManager(InfinityDbHandle db, Object dbLock) {
        this.db = db;
        this.dbLock = dbLock;
        this.watchChecker = new WatchChecker();
        this.debug = AppConfig.getsConfig().getMailer().isDebug();
        Thread watchCheckerThread = new Thread((Runnable)this.watchChecker, "FE-WatchChecker");
        watchCheckerThread.setDaemon(true);
        watchCheckerThread.start();
        this.dailyWatchCheckTrigger = new Timer("FE-WatchDaily", true);
        this.dailyWatchCheckTrigger.schedule(new TimerTask(){

            public void run() {
                Logs.APP_LOG.debug((Object)"checking daily watches");
                WatchManager.this.watchChecker.triggerCheckDailyWatches();
            }
        }, DateHelper.getEndOfDay(new Date(), AppConfig.getsConfig().getTimezone()), ONE_DAY_MILLIS);
    }

    public void stop() {
        this.stopped = true;
        this.watchChecker.cancel();
        this.dailyWatchCheckTrigger.cancel();
    }

    public boolean isStopped() {
        return this.stopped;
    }

    public void repositoryChanged(String repname) {
        if (this.debug) {
            Logs.APP_LOG.debug((Object)("Notifying watch thread about a change in [" + repname + "] repository "));
        }
        this.watchChecker.repositoryChanged(repname);
    }

    public Watch getWatch(String user, String rep, Path path) throws DbException {
        List userWatches = this.getWatchesForUser(user);
        for (Watch watch : userWatches) {
            if (!watch.isSameEntity(rep, path)) continue;
            return watch;
        }
        return null;
    }

    public Watch getWatch(String user, String rep, Path path, WaybackSpec constraint) throws DbException {
        Watch search = new Watch(user, rep, path, constraint);
        List userWatches = this.getWatchesForUser(user);
        ListIterator it = userWatches.listIterator();
        while (it.hasNext()) {
            Watch watch = (Watch)it.next();
            if (!watch.isEquivalent(search)) continue;
            return watch;
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List getWatchesForUser(String user) throws DbException {
        Object object = this.dbLock;
        synchronized (object) {
            WatchEAV weav = new WatchEAV(this.db.get());
            return weav.getWatchesForUser(user);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List getWatchesForRep(String rep) throws DbException {
        Object object = this.dbLock;
        synchronized (object) {
            WatchEAV weav = new WatchEAV(this.db.get());
            return weav.getWatchesForRep(rep);
        }
    }

    public Watch addWatch(String user, String rep, Path path) throws DbException {
        return this.addWatch(user, rep, path, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Watch addWatch(String user, String rep, Path path, WaybackSpec constraint) throws DbException {
        Object object = this.dbLock;
        synchronized (object) {
            Watch watch = new Watch(user, rep, path, constraint);
            watch.setLastChecked(System.currentTimeMillis());
            WatchEAV weav = new WatchEAV(this.db.get());
            weav.add(watch);
            return watch;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void updateWatch(Watch watch) throws DbException {
        Object object = this.dbLock;
        synchronized (object) {
            WatchEAV weav = new WatchEAV(this.db.get());
            weav.update(watch);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean deleteWatch(long id) throws DbException {
        Object object = this.dbLock;
        synchronized (object) {
            WatchEAV weav = new WatchEAV(this.db.get());
            weav.delete(id);
            return true;
        }
    }

    public boolean deleteWatch(String user, String rep, Path path) throws DbException {
        List userWatches = this.getWatchesForUser(user);
        ListIterator it = userWatches.listIterator();
        while (it.hasNext()) {
            Watch watch = (Watch)it.next();
            if (!watch.isSameEntity(rep, path)) continue;
            return this.deleteWatch(watch.getId());
        }
        return false;
    }

    public boolean deleteWatch(String user, String rep, Path path, WaybackSpec constraint) throws DbException {
        Watch deleting = new Watch(user, rep, path, constraint);
        List userWatches = this.getWatchesForUser(user);
        ListIterator it = userWatches.listIterator();
        while (it.hasNext()) {
            Watch watch = (Watch)it.next();
            if (!watch.isEquivalent(deleting)) continue;
            return this.deleteWatch(watch.getId());
        }
        return false;
    }

    class WatchChecker
    implements Runnable {
        private final Set repQueue = new LinkedHashSet();
        private boolean doDailyWatchCheck = false;
        private volatile boolean stopping = false;

        WatchChecker() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void repositoryChanged(String repname) {
            Set set = this.repQueue;
            synchronized (set) {
                if (!this.repQueue.contains(repname)) {
                    this.repQueue.add(repname);
                    this.repQueue.notify();
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void triggerCheckDailyWatches() {
            Set set = this.repQueue;
            synchronized (set) {
                this.doDailyWatchCheck = true;
                this.repQueue.notify();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void cancel() {
            Set set = this.repQueue;
            synchronized (set) {
                this.stopping = true;
                this.repQueue.notify();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() {
            int numExceptionsCaught = 0;
            block7: while (!this.stopping) {
                try {
                    String rep = null;
                    Set set = this.repQueue;
                    synchronized (set) {
                        while (!this.doDailyWatchCheck && this.repQueue.isEmpty()) {
                            try {
                                this.repQueue.wait();
                            }
                            catch (InterruptedException e2) {
                                // empty catch block
                            }
                            if (!this.stopping) continue;
                            break block7;
                        }
                        if (!this.doDailyWatchCheck && !this.repQueue.isEmpty()) {
                            rep = (String)this.repQueue.iterator().next();
                            this.repQueue.remove(rep);
                        }
                    }
                    if (this.doDailyWatchCheck) {
                        this.checkDailyWatches();
                        this.doDailyWatchCheck = false;
                    }
                    if (rep != null) {
                        Logs.APP_LOG.debug((Object)("watch check triggered for '" + rep + "'"));
                        this.checkWatchesForRep(rep, true);
                    }
                    numExceptionsCaught = 0;
                }
                catch (Exception e3) {
                    Logs.APP_LOG.error((Object)("Exception caught while processing watches: " + e3.getMessage()), (Throwable)e3);
                    if (++numExceptionsCaught <= 50) continue;
                    Logs.APP_LOG.error((Object)"Too many consecutive exceptions encountered in watch processing. Watches will be stopped. Please report this problem by raising Support Request in Atlassian Support system");
                    break;
                }
            }
            Logs.APP_LOG.debug((Object)"Leaving watch thread");
        }

        private void checkDailyWatches() {
            for (RepositoryHandle rep : AppConfig.getsConfig().getRepositoryManager().getHandles()) {
                this.checkWatchesForRep(rep, false);
            }
        }

        private void checkWatchesForRep(String rep, boolean instant) {
            this.checkWatchesForRep(AppConfig.getsConfig().getRepositoryManager().getRepository(rep), instant);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void checkWatchesForRep(RepositoryHandle repHandle, boolean instant) {
            if (WatchManager.this.debug) {
                Logs.APP_LOG.debug((Object)("checkWatchesForRep [" + repHandle + "] instant [" + instant + "]"));
            }
            if (!AppConfig.getsConfig().getMailer().isConfigured()) {
                return;
            }
            if (!repHandle.getCfg().isWatchesEnabled()) {
                return;
            }
            if (!repHandle.isRunning()) {
                return;
            }
            try {
                Disposer.pushThreadInstance();
                RepositoryEngine repEngine = repHandle.acquireEngine();
                if (!repEngine.getStatus().isDoneFullSlurp()) {
                    Logs.APP_LOG.debug((Object)("not checking watches on [" + repHandle.getName() + "]: still indexing."));
                    return;
                }
                List repWatches = WatchManager.this.getWatchesForRep(repHandle.getName());
                UserManager um = AppConfig.getsConfig().getUserManager();
                UserProfileManager upm = AppConfig.getsConfig().getUserProfileManager();
                Logs.APP_LOG.debug((Object)("checking " + repWatches.size() + " watches on '" + repHandle.getName() + "'"));
                for (Watch watch : repWatches) {
                    UserLogin user;
                    if (WatchManager.this.debug) {
                        Logs.APP_LOG.debug((Object)("Processing watch [" + watch.toString() + "]"));
                    }
                    if ((user = um.createTrustedUserLogin(watch.getUser(), true, false)) == null) {
                        Logs.APP_LOG.error((Object)("Could not create trusted user login for user [" + watch.getUser() + "]. Notification skipped for this user."));
                        continue;
                    }
                    if (!um.hasPermissionToAccess(user, repHandle)) {
                        Logs.APP_LOG.debug((Object)("user '" + user.getUsername() + "' doesn't have perms to check watch on '" + repHandle.getName() + "'"));
                        continue;
                    }
                    UserProfile profile = upm.getProfile(user.getUsername());
                    if (WatchManager.this.debug) {
                        Logs.APP_LOG.debug((Object)("User profile [" + profile + "]"));
                    }
                    if (profile != null) {
                        if (instant == (profile.getWatchMode() == 0)) {
                            List changesets = WatchManager.this.checkWatch(watch, repEngine);
                            if (WatchManager.this.debug) {
                                Logs.APP_LOG.debug((Object)("sending " + changesets.size() + " changesets"));
                            }
                            if (changesets.size() <= 0) continue;
                            WatchManager.this.sendEmailForChangesets(profile, repEngine, watch.getPath().toString(), changesets, instant);
                            continue;
                        }
                        if (!WatchManager.this.debug) continue;
                        Logs.APP_LOG.debug((Object)("Not checking watch of wrong type (at this time) " + profile.getWatchMode()));
                        continue;
                    }
                    Logs.APP_LOG.warn((Object)("unable to load profile for user [" + user.getUsername() + "]"));
                }
            }
            catch (RepositoryHandle.StateException e2) {
                Logs.APP_LOG.warn((Object)("Not checking watches for repository [" + repHandle.getName() + "] at this time. Repository not running."));
            }
            catch (Exception e3) {
                Logs.APP_LOG.error((Object)("Exception processing watches for repository [" + repHandle.getName() + "]"), (Throwable)e3);
            }
            finally {
                Disposer.popThreadInstance();
            }
        }
    }
}

