/*
 * Decompiled with CFR 0.152.
 */
package com.cenqua.fisheye.web.admin.actions;

import com.cenqua.fisheye.AppConfig;
import com.cenqua.fisheye.config1.ConfigDocument;
import com.cenqua.fisheye.license.LicenseInfo;
import com.cenqua.fisheye.util.LargeNumberFormatter;
import com.opensymphony.xwork.ActionSupport;
import java.text.DecimalFormat;

public class SystemInfoAction
extends ActionSupport {
    private ConfigDocument.Config cfg;
    private final DecimalFormat df = new DecimalFormat("###");
    private final DecimalFormat pcf = new DecimalFormat("###%");

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String getFormattedNum(long num) {
        DecimalFormat decimalFormat = this.df;
        synchronized (decimalFormat) {
            return LargeNumberFormatter.formatValue(this.df, (double)num);
        }
    }

    public String getTotalMemory() {
        return this.getFormattedNum(Runtime.getRuntime().totalMemory());
    }

    public String getFreeMemory() {
        return this.getFormattedNum(Runtime.getRuntime().freeMemory());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getUsedMemoryPcStr() {
        long total = Runtime.getRuntime().totalMemory();
        long free = Runtime.getRuntime().freeMemory();
        if (total == 0L) {
            return "100%";
        }
        DecimalFormat decimalFormat = this.pcf;
        synchronized (decimalFormat) {
            return this.pcf.format((float)(total - free) / (float)total);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getFreeMemoryPcStr() {
        long total = Runtime.getRuntime().totalMemory();
        long free = Runtime.getRuntime().freeMemory();
        if (total == 0L) {
            return "0%";
        }
        DecimalFormat decimalFormat = this.pcf;
        synchronized (decimalFormat) {
            return this.pcf.format((float)free / (float)total);
        }
    }

    public ConfigDocument.Config getCfg() {
        return this.cfg;
    }

    public LicenseInfo getLicense() {
        return AppConfig.getsConfig().getLicense();
    }

    public String getFisheyeHome() {
        return AppConfig.getAppHome().getAbsolutePath();
    }

    public String getFisheyeInst() {
        return AppConfig.getInstanceDir().getAbsolutePath();
    }

    public String getJavaVersion() {
        return System.getProperty("java.version");
    }

    public String getJavaVendor() {
        return System.getProperty("java.vendor");
    }

    public String getJVMVersion() {
        return System.getProperty("java.vm.specification.version");
    }

    public String getJVMVendor() {
        return System.getProperty("java.vm.specification.vendor");
    }

    public String getJVMImplementationVersion() {
        return System.getProperty("java.vm.version");
    }

    public String getJavaRuntimeName() {
        return System.getProperty("java.runtime.name");
    }

    public String getJavaVMName() {
        return System.getProperty("java.vm.name");
    }

    public String getOSInfo() {
        return System.getProperty("os.name") + " " + System.getProperty("os.version");
    }

    public String getOSArch() {
        return System.getProperty("os.arch");
    }

    public String execute() throws Exception {
        this.cfg = AppConfig.getsConfig().getConfig();
        return "success";
    }

    public String forceGC() throws Exception {
        System.gc();
        return "success";
    }
}

