/*
 * Decompiled with CFR 0.152.
 */
package com.cenqua.fisheye.web.admin.actions.sec;

import com.cenqua.fisheye.AppConfig;
import com.cenqua.fisheye.config1.ConfigDocument;
import com.cenqua.fisheye.config1.LdapConfigType;
import com.cenqua.fisheye.config1.SecurityType;
import com.cenqua.fisheye.util.Interval;
import com.opensymphony.xwork.ActionSupport;

public class LDAPEditAction
extends ActionSupport {
    private LdapConfigType ldap;

    public LDAPEditAction() {
        SecurityType sec = this.getCfg().getSecurity();
        if (sec.isSetLdap()) {
            this.ldap = sec.getLdap();
        } else {
            this.ldap = LdapConfigType.Factory.newInstance();
            this.ldap.setAutoAdd(true);
            this.ldap.setUrl("ldap://localhost:389");
            this.ldap.setBaseDn("dc=example,dc=com");
            this.ldap.setFilter("(uid=${USERNAME})");
            this.ldap.setUidAttr("uid");
            this.ldap.setPositiveCacheTtl("5 mins");
        }
    }

    public LdapConfigType getLdap() {
        return this.ldap;
    }

    public ConfigDocument.Config getCfg() {
        return AppConfig.getsConfig().getConfig();
    }

    public String doDefault() throws Exception {
        return "success";
    }

    public String execute() throws Exception {
        if ("".equals(this.ldap.getInitialDn())) {
            this.ldap.unsetInitialDn();
            this.ldap.unsetInitialSecret();
        }
        if ("".equals(this.ldap.getEmailAttr())) {
            this.ldap.unsetEmailAttr();
        }
        this.getCfg().getSecurity().setLdap(this.ldap);
        AppConfig.getsConfig().saveConfig();
        AppConfig.getsConfig().getUserManager().reload(this.getCfg());
        return "success";
    }

    public void validate() {
        if (this.hasErrors()) {
            return;
        }
        try {
            Interval ttl = new Interval(this.ldap.getPositiveCacheTtl());
            this.ldap.setPositiveCacheTtl(ttl.toString());
        }
        catch (NumberFormatException ex) {
            this.addFieldError("ldap.emailAttr", "Invalid interval format. Use something like \"15 minutes\",\"15m\",\"2 hours\",\"2h\",\"1 day\",\"1d\"");
        }
    }
}

