/*
 * Decompiled with CFR 0.152.
 */
package com.cenqua.fisheye.web.admin.actions.trustedapps;

import com.atlassian.fisheye.trustedapplications.FisheyeTrustedApplication;
import com.atlassian.fisheye.trustedapplications.FisheyeTrustedApplicationException;
import com.atlassian.fisheye.trustedapplications.FisheyeTrustedApplicationsManager;
import com.atlassian.fisheye.trustedapplications.TrustedApplicationData;
import com.atlassian.security.auth.trustedapps.Application;
import com.cenqua.fisheye.util.StringUtil;
import com.cenqua.fisheye.web.admin.actions.BaseAdminAction;
import java.net.MalformedURLException;
import java.net.URL;

public class UpdateTrustedAppAction
extends BaseAdminAction {
    private FisheyeTrustedApplicationsManager trustedApplicationManager;
    private TrustedApplicationData application = new TrustedApplicationData();
    private String action;

    public TrustedApplicationData getApplication() {
        return this.application;
    }

    public String execute() {
        if ("Get Id".equals(this.action)) {
            if (StringUtil.nullOrEmpty(this.application.getName())) {
                this.addActionError("You need to provide a URL for the application you wish to trust.");
                return "noid";
            }
            String url = this.application.getName();
            if (!this.isValidUrlPrefix(url)) {
                url = "http://" + url;
            }
            try {
                URL trustUrl = new URL(url);
            }
            catch (MalformedURLException e2) {
                this.addActionError("Malformed URL: " + e2.getMessage());
                return "noid";
            }
            try {
                Application app = this.trustedApplicationManager.getEncryptionProvider().getApplicationCertificate(url);
                this.application.setId(app.getID());
                this.application.setPublicKey(app.getPublicKey());
            }
            catch (Throwable t) {
                this.addActionError("An error occurred connecting to '" + url + "': " + t.getMessage());
                return "noid";
            }
            return "idupdated";
        }
        if ("Save".equals(this.action)) {
            FisheyeTrustedApplication trustedApp;
            if (StringUtil.nullOrEmpty(this.application.getId())) {
                this.addActionError("You need to get an id from the remote application before you can trust it. Enter a URL and click 'Get Id'.");
                return "noid";
            }
            try {
                trustedApp = TrustedApplicationData.fromData(this.application, this.trustedApplicationManager.getEncryptionProvider());
            }
            catch (FisheyeTrustedApplicationException e3) {
                this.addActionError("Invalid settings: " + e3.getMessage());
                return "input";
            }
            if (this.trustedApplicationManager.getTrustedApplication(trustedApp.getID()) != null) {
                this.trustedApplicationManager.updateApplication(trustedApp);
            } else {
                this.trustedApplicationManager.addTrustedApplication(trustedApp);
            }
            return "success";
        }
        this.addActionError("Unknown action '" + this.action + "'.");
        return "error";
    }

    private boolean isValidUrlPrefix(String url) {
        return url.startsWith("http://") || url.startsWith("https://");
    }

    public void setTrustedApplicationManager(FisheyeTrustedApplicationsManager trustedApplicationManager) {
        this.trustedApplicationManager = trustedApplicationManager;
    }

    public void setAction(String action) {
        this.action = action;
    }

    public void validate() {
        if (this.application.getCertificateTimeout() < 0L) {
            this.addActionError("Timeout cannot be negative");
        }
    }
}

