/*
 * Decompiled with CFR 0.152.
 */
package com.cenqua.fisheye.web.dirtree;

import com.cenqua.fisheye.AppConfig;
import com.cenqua.fisheye.Path;
import com.cenqua.fisheye.cache.RevisionCache;
import com.cenqua.fisheye.infinitydb.query3.AndQuery3;
import com.cenqua.fisheye.infinitydb.query3.NotQuery3;
import com.cenqua.fisheye.infinitydb.query3.Query3;
import com.cenqua.fisheye.infinitydb.query3.TermQuery3;
import com.cenqua.fisheye.logging.Logs;
import com.cenqua.fisheye.lucene.LuceneConnection;
import com.cenqua.fisheye.rep.DbException;
import com.cenqua.fisheye.rep.impl.CommonQuery3Helper;
import com.cenqua.fisheye.rep.impl.CommonSchema;
import com.cenqua.fisheye.svn.SvnLogicalPathMatcher;
import com.cenqua.fisheye.svn.SvnRepositoryEngine;
import com.cenqua.fisheye.util.LRUCache;
import com.cenqua.fisheye.web.WaybackSpec;
import com.cenqua.fisheye.web.dirtree.DirTreeCache;
import com.cenqua.obfuscate.idbk4uide._Cu;
import com.cenqua.obfuscate.idbk4uide._k4uideIDB;

class DirTreeContextImpl
implements DirTreeCache.Context {
    private AndQuery3 queryBase;
    private Query3 queryForHead;
    private DirTreeCache cache;
    private final boolean findLogical = false;

    public DirTreeContextImpl(DirTreeCache cache, WaybackSpec wb) {
        this.cache = cache;
        this.makeHeadQuery(wb);
    }

    private void makeHeadQuery(WaybackSpec wb) {
        Path rootpath = new Path();
        RevisionCache rc = this.cache.eng.getRevisionCache();
        this.queryBase = rc.findRevisionsUnderDirQuery3(rootpath, false);
        Query3 deletedQuery = CommonQuery3Helper.findDeletedRevisionsQuery3();
        this.queryBase.addClause(new NotQuery3(deletedQuery));
        String br = null;
        if (wb != null) {
            AndQuery3 clause = wb.getConstraintQuery3(true);
            if (clause != null) {
                this.queryBase.addClause(clause);
            }
            br = wb.getBranch();
        }
        this.queryForHead = br == null ? new TermQuery3(CommonSchema.E_HEAD_IN_ANY_BRANCH_REVIDS, _Cu.alloc(), null) : new TermQuery3(CommonSchema.E_HEAD_IN_BRANCH_TO_REVID, br, null);
    }

    public boolean isEmptyOfFiles(final Path path) {
        SvnRepositoryEngine eng;
        SvnLogicalPathMatcher matcher;
        Path tagRoot;
        if (AppConfig.Hacks.DISABLE_DIRTREE_EMPTY_CHECKS) {
            return false;
        }
        if (this.cache.eng instanceof SvnRepositoryEngine && (tagRoot = (matcher = (eng = (SvnRepositoryEngine)this.cache.eng).getPathMatcher()).getTagRoot(path)) != null) {
            return false;
        }
        final AndQuery3 bq2 = this.makeIsEmptyQuery(path);
        DirTreeCache.CacheKey key = new DirTreeCache.CacheKey(bq2, path);
        LRUCache.ValueFactory valueFactory = new LRUCache.ValueFactory(){

            public Object createValue() throws Exception {
                boolean isempty;
                long t1 = System.currentTimeMillis();
                LuceneConnection conn = null;
                _k4uideIDB db = ((DirTreeContextImpl)DirTreeContextImpl.this).cache.eng.getRevisionCache().getInfDb().get();
                boolean bl = isempty = !bq2.existAny(db, conn);
                if (Logs.PERF_LOG.isDebugEnabled()) {
                    long t2 = System.currentTimeMillis();
                    Logs.PERF_LOG.debug((Object)("isempty check for /" + path + " in " + (t2 - t1) + "ms"));
                }
                return new DirTreeCache.Node(isempty);
            }

            public void updateValue(Object key, Object newval) throws Exception {
            }
        };
        try {
            DirTreeCache.Node node = (DirTreeCache.Node)this.cache.dirinfoCache.get(key, valueFactory);
            return node.isEmpty;
        }
        catch (LRUCache.ValueFactoryException e2) {
            Logs.APP_LOG.warn((Object)"error counting nonempty files", (Throwable)e2);
            return false;
        }
    }

    private AndQuery3 makeIsEmptyQuery(Path path) {
        RevisionCache rc = this.cache.eng.getRevisionCache();
        AndQuery3 bq2 = rc.findRevisionsUnderDirQuery3(path, false);
        bq2.addClause(this.queryBase);
        bq2.addClause(this.queryForHead);
        return bq2;
    }

    void calculateWith(LuceneConnection conn, DirTreeCache.Visitor v) throws DbException {
        v.visit(this);
    }
}

