/*
 * Decompiled with CFR 0.152.
 */
package com.cenqua.fisheye.web.rdiff;

import com.cenqua.fisheye.Path;
import com.cenqua.fisheye.cache.RevisionCache;
import com.cenqua.fisheye.cvsrep.RCSParser;
import com.cenqua.fisheye.diff.LineComparator;
import com.cenqua.fisheye.rep.ChangeSet;
import com.cenqua.fisheye.rep.DbException;
import com.cenqua.fisheye.rep.FileRevision;
import com.cenqua.fisheye.web.BaseAction;
import com.cenqua.fisheye.web.FishEyePathInfo;
import com.cenqua.fisheye.web.rdiff.PatchPrinter;
import java.io.IOException;
import java.io.Writer;
import java.util.Iterator;
import java.util.LinkedList;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

public class RDiffAction
extends BaseAction {
    private RevisionCache mRep;
    private boolean recursive = true;
    private Writer mOut;
    private PatchPrinter mPrinter;

    public BaseAction handleRequest() throws ServletException, IOException, DbException, RCSParser.ParseException {
        HttpServletRequest req = this.getRequest();
        FishEyePathInfo pi = this.getPathInfo();
        if (!req.getParameterNames().hasMoreElements()) {
            req.getRequestDispatcher("/WEB-INF/jsp/rdiff_usage.jsp").forward((ServletRequest)req, (ServletResponse)this.getResponse());
            return null;
        }
        Path lpath = pi.getLocalPath();
        this.mRep = this.getPathInfo().getEngine().getRevisionCache();
        String csid = req.getParameter("csid");
        String r1 = req.getParameter("r1");
        String r2 = req.getParameter("r2");
        LinkedList<String> errors = new LinkedList<String>();
        if (csid != null) {
            RevisionCache repc = this.getRepositoryCache();
            ChangeSet cs = repc.getChangeSet(csid);
            if (cs == null) {
                errors.add("could not find changeset " + csid);
            } else {
                this.sendChangeset(cs);
            }
        } else if (r1 != null && r2 != null) {
            this.sendRecursive(lpath, r1, r2);
        } else {
            errors.add("one of csid, r1 and r2, or D1 and D2 must be given");
        }
        if (!errors.isEmpty()) {
            req.setAttribute("errors", errors);
            req.getRequestDispatcher("/WEB-INF/jsp/rdiff_usage.jsp").forward((ServletRequest)req, (ServletResponse)this.getResponse());
            return null;
        }
        return null;
    }

    private void parseCommonOpts(PatchPrinter.PatchOptions opts) {
        String u;
        HttpServletRequest req = this.getRequest();
        if (req.getParameter("R") != null) {
            this.recursive = true;
        }
        if (req.getParameter("l") != null) {
            this.recursive = false;
        }
        if (req.getParameter("N") != null) {
            opts.absentAsEmpty = true;
        }
        StringBuffer ignoreOpts = new StringBuffer(4);
        if (req.getParameter("w") != null) {
            ignoreOpts.append("w");
        }
        if (req.getParameter("b") != null) {
            ignoreOpts.append("b");
        }
        if (req.getParameter("B") != null) {
            ignoreOpts.append("B");
        }
        if (ignoreOpts.length() > 0) {
            opts.ignore = LineComparator.fromDiffOption(ignoreOpts.toString());
        }
        if ((u = req.getParameter("u")) != null) {
            try {
                opts.linesOfContext = Integer.parseInt(u);
            }
            catch (NumberFormatException e2) {
                opts.linesOfContext = 3;
            }
        }
        opts.kOpt = req.getParameter("k");
    }

    private void sendRecursive(Path path, String r1, String r2) throws IOException, DbException {
        this.startPatch();
        if (this.mRep.isFile(path)) {
            this.mPrinter.sendFileDiff(path, r1, r2);
        } else if (this.mRep.isDir(path)) {
            Path[] children;
            for (Path file : children = this.mRep.listFiles(path)) {
                this.sendRecursive(file, r1, r2);
            }
            if (this.recursive) {
                for (Path file : children = this.mRep.listDirs(path)) {
                    this.sendRecursive(file, r1, r2);
                }
            }
        }
        this.endPatch();
    }

    private void sendChangeset(ChangeSet cs) throws IOException, DbException {
        this.startPatch();
        Path topPath = this.getPathInfo().getLocalPath();
        Iterator<FileRevision> i2 = cs.getRevisionInfos();
        while (i2.hasNext()) {
            FileRevision riB = i2.next();
            String rB = riB.getRevision();
            Path path = riB.getPath();
            if (!path.hasPrefix(topPath) || !this.mRep.isFile(path)) continue;
            String rA = riB.getAncestorRevision();
            if (rA == null) {
                this.mPrinter.sendAddedFile(path, rB);
                continue;
            }
            this.mPrinter.sendFileDiff(path, rA, rB);
        }
        this.endPatch();
    }

    private void startPatch() throws IOException {
        HttpServletResponse resp = this.getResponse();
        resp.setContentType("text/plain; charset=UTF-8");
        this.mOut = resp.getWriter();
        this.mPrinter = new PatchPrinter(this.mRep, this.mOut);
        this.parseCommonOpts(this.mPrinter.getOpts());
    }

    private void endPatch() throws IOException {
        this.mOut.flush();
    }
}

