/*
 * Decompiled with CFR 0.152.
 */
package com.cenqua.fisheye.web.security;

import com.cenqua.fisheye.logging.Logs;
import com.cenqua.fisheye.util.MD5;
import com.cenqua.fisheye.web.security.CustomGimpyEngine;
import com.octo.captcha.engine.CaptchaEngine;
import com.octo.captcha.service.CaptchaServiceException;
import com.octo.captcha.service.image.DefaultManageableImageCaptchaService;
import java.awt.image.BufferedImage;
import java.security.SecureRandom;
import java.util.Locale;
import java.util.Random;

public class CaptchaManager {
    private static final Random RANDOM;
    private static final CaptchaManager INSTANCE;
    private final DefaultManageableImageCaptchaService captcha = new DefaultManageableImageCaptchaService();

    private CaptchaManager() {
        this.setupCaptcha();
    }

    public static CaptchaManager getInstance() {
        return INSTANCE;
    }

    private void setupCaptcha() {
        CustomGimpyEngine engine = new CustomGimpyEngine();
        this.captcha.setCaptchaEngine((CaptchaEngine)engine);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String makeCaptchaId() {
        int nRandom = 16;
        byte[] b2 = new byte[16];
        Random random = RANDOM;
        synchronized (random) {
            RANDOM.nextBytes(b2);
        }
        return MD5.hexEncode(b2);
    }

    public BufferedImage getImageChallengeForID(String id, Locale locale) throws CaptchaServiceException {
        return this.captcha.getImageChallengeForID(id, locale);
    }

    public Boolean validateResponseForID(String id, String response) throws CaptchaServiceException {
        return this.captcha.validateResponseForID(id, (Object)response);
    }

    static {
        long t0 = System.currentTimeMillis();
        RANDOM = new SecureRandom();
        RANDOM.nextBytes(new byte[1]);
        long t1 = System.currentTimeMillis();
        Logs.PERF_LOG.debug((Object)("created SecureRandom in " + (t1 - t0) + "ms"));
        INSTANCE = new CaptchaManager();
    }
}

