/*
 * Decompiled with CFR 0.152.
 */
package com.cenqua.license;

import com.cenqua.license.AtlassianLicenseConverterFactory;
import com.cenqua.license.CenquaLicense;
import com.cenqua.util.Base64;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.LineNumberReader;
import java.io.StringReader;
import java.security.InvalidKeyException;
import java.security.KeyFactory;
import java.security.NoSuchAlgorithmException;
import java.security.PublicKey;
import java.security.Signature;
import java.security.SignatureException;
import java.security.spec.InvalidKeySpecException;
import java.security.spec.X509EncodedKeySpec;
import java.util.Properties;

public final class LicenseDecoder {
    private static final String GENERIC_ERROR = "Invalid license file";
    private static final byte[] XOR_KEY = new byte[]{95, -10, -121, -123, 63, -70, 119, 90, -121, -90, 32, -21, -64, 95, -37, -65, 61, -13, -53, 35, 86, 17, 35, 23, -84, 90, -36, 80, 46, -122, 73, 41, -27, -124, -17, 38, -55, 40, 82, 100, 5, -67, -99, 18, -127, -122, -48, -96, -84, 20, -102, -89, 80, -93, -52, -114, 84, -74, -113, -94, -90, -49, 10, 111, 80, 18, 76, 117, -126, -44, -104, 97, 119, 43, -39, -114, 54, 10, -118, -81, -71, -93, 49, -97, 120, 72, 124, -61, 68, 22, 100, 78, -77, 34, 91, 29, -31, 27, 68, -104};
    private static final byte[] PUBLIC_RSA_KEY_BYTES = new byte[]{48, -127, -97, 48, 13, 6, 9, 42, -122, 72, -122, -9, 13, 1, 1, 1, 5, 0, 3, -127, -115, 0, 48, -127, -119, 2, -127, -127, 0, -75, -94, 109, 51, 126, 55, -127, 1, -62, -56, 12, -4, -115, 118, -52, 57, -16, -19, 33, -48, -125, 88, 14, 79, 74, 62, -83, 120, 122, -70, 42, -79, 33, -78, 59, -128, 126, 121, -4, -20, -113, 73, -41, 48, 91, 95, 11, -65, -71, 108, 33, 96, 53, -21, 44, 60, 112, 84, 69, 95, -82, 65, 32, -49, 61, 35, -77, -6, 6, 19, 113, 102, -54, 55, 21, 28, 6, 89, -87, -84, -13, -109, -18, 113, 116, -21, 96, -78, 86, -15, -82, -76, -37, 24, 27, -20, -28, 127, -31, -33, 64, 31, 97, 80, -44, 93, 60, -59, -97, -51, 111, -36, -86, 19, -27, -1, 14, -77, -118, -49, 117, -106, -50, -16, -78, 117, 103, -71, 2, 3, 1, 0, 1};
    private static final String MAGIC_STRING = "0xDEDEFACE";

    private static String getCertificateFromLicenseFile(InputStream input) throws IOException {
        boolean gatherCert;
        LineNumberReader in = new LineNumberReader(new InputStreamReader(input, "UTF-8"));
        String line = in.readLine();
        String cert = "";
        if (line == null) {
            return cert;
        }
        boolean cenquaLicense = line.startsWith("Product:");
        boolean bl = gatherCert = !cenquaLicense;
        while (line != null && !line.startsWith("License Agreement: ") && line.trim().length() != 0) {
            if (gatherCert) {
                cert = cert + line.trim() + (cenquaLicense ? "" : "\n");
            } else if (line.startsWith("Certificate: ")) {
                cert = line.substring("Certificate: ".length());
                gatherCert = true;
            }
            line = in.readLine();
        }
        return cert;
    }

    private static byte[] xorBytes(byte[] data) {
        int keyCursor = 0;
        for (int i2 = 0; i2 < data.length; ++i2) {
            char c2 = (char)(data[i2] ^ XOR_KEY[keyCursor % XOR_KEY.length]);
            data[i2] = (byte)c2;
            ++keyCursor;
        }
        return data;
    }

    public static CenquaLicense decode(InputStream input) throws IOException {
        if (input == null) {
            throw new IOException("no license file found");
        }
        return LicenseDecoder.decodeFromCert(LicenseDecoder.getCertificateFromLicenseFile(input));
    }

    public static CenquaLicense decodeFromCert(String cert) throws IOException {
        if (cert == null) {
            throw new IOException("Invalid license file [E1212].");
        }
        if (cert.indexOf("\n") != -1) {
            return AtlassianLicenseConverterFactory.getInstance().getCenquaLicense(cert);
        }
        try {
            byte[] de64 = Base64.decode(cert);
            int length = ((0xFF & de64[0]) << 24) + ((0xFF & de64[1]) << 16) + ((0xFF & de64[2]) << 8) + (0xFF & de64[3]);
            if (length <= 0 || de64.length - length - 4 <= 0) {
                throw new IOException("Invalid license file [E1200].");
            }
            byte[] licData = new byte[length];
            byte[] signData = new byte[de64.length - licData.length - 4];
            try {
                System.arraycopy(de64, 4, licData, 0, length);
                System.arraycopy(de64, 4 + length, signData, 0, signData.length);
            }
            catch (Exception e2) {
                throw new IOException("Invalid license file [E1201].");
            }
            if (!LicenseDecoder.verifySignature(licData, signData)) {
                throw new IOException("Invalid license file [E1202].");
            }
            LineNumberReader in = new LineNumberReader(new StringReader(new String(LicenseDecoder.xorBytes(licData), "UTF-8")));
            if (in.readLine().equals(MAGIC_STRING)) {
                boolean terminates;
                String productName = in.readLine();
                long softExpiry = 0L;
                long hardExpiry = 0L;
                boolean expires = Boolean.valueOf(in.readLine());
                if (expires) {
                    softExpiry = Long.parseLong(in.readLine());
                }
                if (terminates = Boolean.valueOf(in.readLine()).booleanValue()) {
                    hardExpiry = Long.parseLong(in.readLine());
                }
                String supportedVersions = in.readLine();
                String licenseName = in.readLine();
                in.readLine();
                Properties props = new Properties();
                String line = in.readLine();
                while (line != null) {
                    String key = line.substring(0, line.indexOf("="));
                    String val = line.length() > line.indexOf("=") + 1 ? line.substring(line.indexOf("=") + 1) : "";
                    props.put(key, val);
                    line = in.readLine();
                }
                return new CenquaLicense(productName, licenseName, supportedVersions, softExpiry, hardExpiry, props);
            }
        }
        catch (StringIndexOutOfBoundsException e3) {
            throw new IOException("Invalid license file [E1203].");
        }
        catch (ArrayIndexOutOfBoundsException e4) {
            throw new IOException("Invalid license file [E1204].");
        }
        catch (NumberFormatException e5) {
            throw new IOException("Invalid license file [E1209].");
        }
        catch (NullPointerException e6) {
            throw new IOException("Invalid license file [E1210].");
        }
        catch (NegativeArraySizeException e7) {
            throw new IOException("Invalid license file [E1213].");
        }
        throw new IOException("Invalid license file [E1211].");
    }

    private static boolean verifySignature(byte[] licData, byte[] signData) throws IOException {
        KeyFactory keyFactory = null;
        try {
            keyFactory = KeyFactory.getInstance("RSA");
        }
        catch (NoSuchAlgorithmException e2) {
            return true;
        }
        try {
            X509EncodedKeySpec publicKeySpec = new X509EncodedKeySpec(PUBLIC_RSA_KEY_BYTES);
            PublicKey publicKey = keyFactory.generatePublic(publicKeySpec);
            Signature sign = Signature.getInstance("SHA1withRSA");
            sign.initVerify(publicKey);
            sign.update(licData);
            return sign.verify(signData);
        }
        catch (NoSuchAlgorithmException e3) {
            throw new IOException("Invalid license file [E1205].");
        }
        catch (InvalidKeySpecException e4) {
            throw new IOException("Invalid license file [E1206].");
        }
        catch (InvalidKeyException e5) {
            throw new IOException("Invalid license file [E1207].");
        }
        catch (SignatureException e6) {
            throw new IOException("Invalid license file [E1208].");
        }
    }
}

