/*
 * Decompiled with CFR 0.152.
 */
package org.tigris.subversion.javahl;

import com.cenqua.fisheye.logging.Logs;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.util.Date;
import org.tigris.subversion.javahl.ChangePath;
import org.tigris.subversion.javahl.LogMessage;

public class JavaHLFactory {
    private static Constructor lmConstructor;

    public static ChangePath createChangePath(String path, long copyFromRev, String copyFromPath, char action) {
        return new ChangePath(path, copyFromRev, copyFromPath, action);
    }

    public static LogMessage createLogMessage(String message, Date revDate, long revision, String author, ChangePath[] changePaths) {
        if (lmConstructor == null) {
            return null;
        }
        Class<?>[] paramTypes = lmConstructor.getParameterTypes();
        try {
            if (paramTypes[0] == String.class) {
                return (LogMessage)lmConstructor.newInstance(message, revDate, revision, author, changePaths);
            }
            return (LogMessage)lmConstructor.newInstance(changePaths, revision, message, revDate, author);
        }
        catch (IllegalAccessException e2) {
            Logs.APP_LOG.warn((Object)"Error creating log message");
        }
        catch (InvocationTargetException e3) {
            Logs.APP_LOG.warn((Object)"Error creating log message");
        }
        catch (InstantiationException e4) {
            Logs.APP_LOG.warn((Object)"Error creating log message");
        }
        return null;
    }

    static {
        Constructor<?>[] constructors;
        Class<LogMessage> lmClass = LogMessage.class;
        for (Constructor<?> constructor : constructors = lmClass.getDeclaredConstructors()) {
            if (constructor.getParameterTypes().length != 5) continue;
            for (Class<?> paramType : constructor.getParameterTypes()) {
                if (paramType != Date.class) continue;
                lmConstructor = constructor;
                break;
            }
            if (lmConstructor != null) break;
        }
    }
}

