/*
 * Decompiled with CFR 0.152.
 */
package cenqua_com_licensing.atlassian.time.base;

import cenqua_com_licensing.atlassian.time.DurationFieldType;
import cenqua_com_licensing.atlassian.time.MutablePeriod;
import cenqua_com_licensing.atlassian.time.Period;
import cenqua_com_licensing.atlassian.time.PeriodType;
import cenqua_com_licensing.atlassian.time.ReadablePeriod;
import cenqua_com_licensing.atlassian.time.format.ISOPeriodFormat;

public abstract class AbstractPeriod
implements ReadablePeriod {
    protected AbstractPeriod() {
    }

    public DurationFieldType[] getFieldTypes() {
        DurationFieldType[] durationFieldTypeArray = new DurationFieldType[this.size()];
        int n = 0;
        while (n < durationFieldTypeArray.length) {
            durationFieldTypeArray[n] = this.getFieldType(n);
            ++n;
        }
        return durationFieldTypeArray;
    }

    public int[] getValues() {
        int[] nArray = new int[this.size()];
        int n = 0;
        while (n < nArray.length) {
            nArray[n] = this.getValue(n);
            ++n;
        }
        return nArray;
    }

    public int get(DurationFieldType durationFieldType) {
        int n = this.indexOf(durationFieldType);
        if (n == -1) {
            return 0;
        }
        return this.getValue(n);
    }

    public boolean isSupported(DurationFieldType durationFieldType) {
        return this.getPeriodType().isSupported(durationFieldType);
    }

    public int indexOf(DurationFieldType durationFieldType) {
        return this.getPeriodType().indexOf(durationFieldType);
    }

    public Period toPeriod() {
        return new Period(this);
    }

    public MutablePeriod toMutablePeriod() {
        return new MutablePeriod(this);
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (!(object instanceof ReadablePeriod)) {
            return false;
        }
        ReadablePeriod readablePeriod = (ReadablePeriod)object;
        if (this.size() != readablePeriod.size()) {
            return false;
        }
        int n = 0;
        int n2 = this.size();
        while (n < n2) {
            if (this.getValue(n) != readablePeriod.getValue(n) || this.getFieldType(n) != readablePeriod.getFieldType(n)) {
                return false;
            }
            ++n;
        }
        return true;
    }

    public int hashCode() {
        int n = 17;
        int n2 = 0;
        int n3 = this.size();
        while (n2 < n3) {
            n = 27 * n + this.getValue(n2);
            n = 27 * n + this.getFieldType(n2).hashCode();
            ++n2;
        }
        return n;
    }

    public String toString() {
        return ISOPeriodFormat.standard().print(this);
    }

    public abstract int getValue(int var1);

    public abstract DurationFieldType getFieldType(int var1);

    public abstract int size();

    public abstract PeriodType getPeriodType();
}

