/*
 * Decompiled with CFR 0.152.
 */
package cenqua_com_licensing.atlassian.time.format;

import cenqua_com_licensing.atlassian.time.Chronology;
import cenqua_com_licensing.atlassian.time.DateTime;
import cenqua_com_licensing.atlassian.time.DateTimeZone;
import cenqua_com_licensing.atlassian.time.ReadablePartial;
import cenqua_com_licensing.atlassian.time.format.DateTimeFormatter;
import cenqua_com_licensing.atlassian.time.format.DateTimeFormatterBuilder;
import cenqua_com_licensing.atlassian.time.format.DateTimeParser;
import cenqua_com_licensing.atlassian.time.format.DateTimeParserBucket;
import cenqua_com_licensing.atlassian.time.format.DateTimePrinter;
import java.io.IOException;
import java.io.Writer;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;

public class DateTimeFormat {
    static final int FULL = 0;
    static final int LONG = 1;
    static final int MEDIUM = 2;
    static final int SHORT = 3;
    static final int NONE = 4;
    static final int DATE = 0;
    static final int TIME = 1;
    static final int DATETIME = 2;
    private static final Map cPatternedCache = new HashMap(7);
    private static final DateTimeFormatter[] cStyleCache = new DateTimeFormatter[25];

    public static DateTimeFormatter forPattern(String string) {
        return DateTimeFormat.createFormatterForPattern(string);
    }

    public static DateTimeFormatter forStyle(String string) {
        return DateTimeFormat.createFormatterForStyle(string);
    }

    public static String patternForStyle(String string, Locale locale) {
        DateTimeFormatter dateTimeFormatter = DateTimeFormat.createFormatterForStyle(string);
        if (locale == null) {
            locale = Locale.getDefault();
        }
        return ((StyleFormatter)dateTimeFormatter.getPrinter()).getPattern(locale);
    }

    public static DateTimeFormatter shortDate() {
        return DateTimeFormat.createFormatterForStyleIndex(3, 4);
    }

    public static DateTimeFormatter shortTime() {
        return DateTimeFormat.createFormatterForStyleIndex(4, 3);
    }

    public static DateTimeFormatter shortDateTime() {
        return DateTimeFormat.createFormatterForStyleIndex(3, 3);
    }

    public static DateTimeFormatter mediumDate() {
        return DateTimeFormat.createFormatterForStyleIndex(2, 4);
    }

    public static DateTimeFormatter mediumTime() {
        return DateTimeFormat.createFormatterForStyleIndex(4, 2);
    }

    public static DateTimeFormatter mediumDateTime() {
        return DateTimeFormat.createFormatterForStyleIndex(2, 2);
    }

    public static DateTimeFormatter longDate() {
        return DateTimeFormat.createFormatterForStyleIndex(1, 4);
    }

    public static DateTimeFormatter longTime() {
        return DateTimeFormat.createFormatterForStyleIndex(4, 1);
    }

    public static DateTimeFormatter longDateTime() {
        return DateTimeFormat.createFormatterForStyleIndex(1, 1);
    }

    public static DateTimeFormatter fullDate() {
        return DateTimeFormat.createFormatterForStyleIndex(0, 4);
    }

    public static DateTimeFormatter fullTime() {
        return DateTimeFormat.createFormatterForStyleIndex(4, 0);
    }

    public static DateTimeFormatter fullDateTime() {
        return DateTimeFormat.createFormatterForStyleIndex(0, 0);
    }

    static void appendPatternTo(DateTimeFormatterBuilder dateTimeFormatterBuilder, String string) {
        DateTimeFormat.parsePatternTo(dateTimeFormatterBuilder, string);
    }

    protected DateTimeFormat() {
    }

    private static void parsePatternTo(DateTimeFormatterBuilder dateTimeFormatterBuilder, String string) {
        int n = string.length();
        int[] nArray = new int[1];
        int n2 = 0;
        while (n2 < n) {
            nArray[0] = n2;
            String string2 = DateTimeFormat.parseToken(string, nArray);
            n2 = nArray[0];
            int n3 = string2.length();
            if (n3 == 0) break;
            char c2 = string2.charAt(0);
            block0 : switch (c2) {
                case 'G': {
                    dateTimeFormatterBuilder.appendEraText();
                    break;
                }
                case 'C': {
                    dateTimeFormatterBuilder.appendCenturyOfEra(n3, n3);
                    break;
                }
                case 'Y': 
                case 'x': 
                case 'y': {
                    if (n3 == 2) {
                        boolean bl = true;
                        if (n2 + 1 < n) {
                            nArray[0] = nArray[0] + 1;
                            if (DateTimeFormat.isNumericToken(DateTimeFormat.parseToken(string, nArray))) {
                                bl = false;
                            }
                            nArray[0] = nArray[0] - 1;
                        }
                        switch (c2) {
                            case 'x': {
                                dateTimeFormatterBuilder.appendTwoDigitWeekyear(new DateTime().getWeekyear() - 30, bl);
                                break block0;
                            }
                        }
                        dateTimeFormatterBuilder.appendTwoDigitYear(new DateTime().getYear() - 30, bl);
                        break;
                    }
                    int n4 = 9;
                    if (n2 + 1 < n) {
                        nArray[0] = nArray[0] + 1;
                        if (DateTimeFormat.isNumericToken(DateTimeFormat.parseToken(string, nArray))) {
                            n4 = n3;
                        }
                        nArray[0] = nArray[0] - 1;
                    }
                    switch (c2) {
                        case 'x': {
                            dateTimeFormatterBuilder.appendWeekyear(n3, n4);
                            break;
                        }
                        case 'y': {
                            dateTimeFormatterBuilder.appendYear(n3, n4);
                            break;
                        }
                        case 'Y': {
                            dateTimeFormatterBuilder.appendYearOfEra(n3, n4);
                        }
                    }
                    break;
                }
                case 'M': {
                    if (n3 >= 3) {
                        if (n3 >= 4) {
                            dateTimeFormatterBuilder.appendMonthOfYearText();
                            break;
                        }
                        dateTimeFormatterBuilder.appendMonthOfYearShortText();
                        break;
                    }
                    dateTimeFormatterBuilder.appendMonthOfYear(n3);
                    break;
                }
                case 'd': {
                    dateTimeFormatterBuilder.appendDayOfMonth(n3);
                    break;
                }
                case 'a': {
                    dateTimeFormatterBuilder.appendHalfdayOfDayText();
                    break;
                }
                case 'h': {
                    dateTimeFormatterBuilder.appendClockhourOfHalfday(n3);
                    break;
                }
                case 'H': {
                    dateTimeFormatterBuilder.appendHourOfDay(n3);
                    break;
                }
                case 'k': {
                    dateTimeFormatterBuilder.appendClockhourOfDay(n3);
                    break;
                }
                case 'K': {
                    dateTimeFormatterBuilder.appendHourOfHalfday(n3);
                    break;
                }
                case 'm': {
                    dateTimeFormatterBuilder.appendMinuteOfHour(n3);
                    break;
                }
                case 's': {
                    dateTimeFormatterBuilder.appendSecondOfMinute(n3);
                    break;
                }
                case 'S': {
                    dateTimeFormatterBuilder.appendFractionOfSecond(n3, n3);
                    break;
                }
                case 'e': {
                    dateTimeFormatterBuilder.appendDayOfWeek(n3);
                    break;
                }
                case 'E': {
                    if (n3 >= 4) {
                        dateTimeFormatterBuilder.appendDayOfWeekText();
                        break;
                    }
                    dateTimeFormatterBuilder.appendDayOfWeekShortText();
                    break;
                }
                case 'D': {
                    dateTimeFormatterBuilder.appendDayOfYear(n3);
                    break;
                }
                case 'w': {
                    dateTimeFormatterBuilder.appendWeekOfWeekyear(n3);
                    break;
                }
                case 'z': {
                    if (n3 >= 4) {
                        dateTimeFormatterBuilder.appendTimeZoneName();
                        break;
                    }
                    dateTimeFormatterBuilder.appendTimeZoneShortName();
                    break;
                }
                case 'Z': {
                    if (n3 == 1) {
                        dateTimeFormatterBuilder.appendTimeZoneOffset(null, false, 2, 2);
                        break;
                    }
                    if (n3 == 2) {
                        dateTimeFormatterBuilder.appendTimeZoneOffset(null, true, 2, 2);
                        break;
                    }
                    dateTimeFormatterBuilder.appendTimeZoneId();
                    break;
                }
                case '\'': {
                    String string3 = string2.substring(1);
                    if (string3.length() == 1) {
                        dateTimeFormatterBuilder.appendLiteral(string3.charAt(0));
                        break;
                    }
                    dateTimeFormatterBuilder.appendLiteral(new String(string3));
                    break;
                }
                default: {
                    throw new IllegalArgumentException("Illegal pattern component: " + string2);
                }
            }
            ++n2;
        }
    }

    private static String parseToken(String string, int[] nArray) {
        StringBuffer stringBuffer = new StringBuffer();
        int n = nArray[0];
        int n2 = string.length();
        char c2 = string.charAt(n);
        if (c2 >= 'A' && c2 <= 'Z' || c2 >= 'a' && c2 <= 'z') {
            stringBuffer.append(c2);
            while (n + 1 < n2) {
                char c3 = string.charAt(n + 1);
                if (c3 == c2) {
                    stringBuffer.append(c2);
                    ++n;
                    continue;
                }
                break;
            }
        } else {
            stringBuffer.append('\'');
            boolean bl = false;
            while (n < n2) {
                c2 = string.charAt(n);
                if (c2 == '\'') {
                    if (n + 1 < n2 && string.charAt(n + 1) == '\'') {
                        ++n;
                        stringBuffer.append(c2);
                    } else {
                        bl = !bl;
                    }
                } else {
                    if (!bl && (c2 >= 'A' && c2 <= 'Z' || c2 >= 'a' && c2 <= 'z')) break;
                    stringBuffer.append(c2);
                }
                ++n;
            }
        }
        nArray[0] = --n;
        return stringBuffer.toString();
    }

    private static boolean isNumericToken(String string) {
        int n = string.length();
        if (n > 0) {
            char c2 = string.charAt(0);
            switch (c2) {
                case 'C': 
                case 'D': 
                case 'F': 
                case 'H': 
                case 'K': 
                case 'S': 
                case 'W': 
                case 'Y': 
                case 'c': 
                case 'd': 
                case 'e': 
                case 'h': 
                case 'k': 
                case 'm': 
                case 's': 
                case 'w': 
                case 'x': 
                case 'y': {
                    return true;
                }
                case 'M': {
                    if (n > 2) break;
                    return true;
                }
            }
        }
        return false;
    }

    private static DateTimeFormatter createFormatterForPattern(String string) {
        if (string == null || string.length() == 0) {
            throw new IllegalArgumentException("Invalid pattern specification");
        }
        DateTimeFormatter dateTimeFormatter = null;
        Map map = cPatternedCache;
        synchronized (map) {
            dateTimeFormatter = (DateTimeFormatter)cPatternedCache.get(string);
            if (dateTimeFormatter == null) {
                DateTimeFormatterBuilder dateTimeFormatterBuilder = new DateTimeFormatterBuilder();
                DateTimeFormat.parsePatternTo(dateTimeFormatterBuilder, string);
                dateTimeFormatter = dateTimeFormatterBuilder.toFormatter();
                cPatternedCache.put(string, dateTimeFormatter);
            }
        }
        return dateTimeFormatter;
    }

    private static DateTimeFormatter createFormatterForStyle(String string) {
        if (string == null || string.length() != 2) {
            throw new IllegalArgumentException("Invalid style specification: " + string);
        }
        int n = DateTimeFormat.selectStyle(string.charAt(0));
        int n2 = DateTimeFormat.selectStyle(string.charAt(1));
        if (n == 4 && n2 == 4) {
            throw new IllegalArgumentException("Style '--' is invalid");
        }
        return DateTimeFormat.createFormatterForStyleIndex(n, n2);
    }

    private static DateTimeFormatter createFormatterForStyleIndex(int n, int n2) {
        int n3 = (n << 2) + n + n2;
        DateTimeFormatter dateTimeFormatter = null;
        DateTimeFormatter[] dateTimeFormatterArray = cStyleCache;
        synchronized (dateTimeFormatterArray) {
            dateTimeFormatter = cStyleCache[n3];
            if (dateTimeFormatter == null) {
                int n4 = 2;
                if (n == 4) {
                    n4 = 1;
                } else if (n2 == 4) {
                    n4 = 0;
                }
                StyleFormatter styleFormatter = new StyleFormatter(n, n2, n4);
                DateTimeFormat.cStyleCache[n3] = dateTimeFormatter = new DateTimeFormatter(styleFormatter, styleFormatter);
            }
        }
        return dateTimeFormatter;
    }

    private static int selectStyle(char c2) {
        switch (c2) {
            case 'S': {
                return 3;
            }
            case 'M': {
                return 2;
            }
            case 'L': {
                return 1;
            }
            case 'F': {
                return 0;
            }
            case '-': {
                return 4;
            }
        }
        throw new IllegalArgumentException("Invalid style character: " + c2);
    }

    static class StyleFormatter
    implements DateTimePrinter,
    DateTimeParser {
        private static final Map cCache = new HashMap();
        private final int iDateStyle;
        private final int iTimeStyle;
        private final int iType;

        StyleFormatter(int n, int n2, int n3) {
            this.iDateStyle = n;
            this.iTimeStyle = n2;
            this.iType = n3;
        }

        public int estimatePrintedLength() {
            return 40;
        }

        public void printTo(StringBuffer stringBuffer, long l, Chronology chronology, int n, DateTimeZone dateTimeZone, Locale locale) {
            DateTimePrinter dateTimePrinter = this.getFormatter(locale).getPrinter();
            dateTimePrinter.printTo(stringBuffer, l, chronology, n, dateTimeZone, locale);
        }

        public void printTo(Writer writer, long l, Chronology chronology, int n, DateTimeZone dateTimeZone, Locale locale) throws IOException {
            DateTimePrinter dateTimePrinter = this.getFormatter(locale).getPrinter();
            dateTimePrinter.printTo(writer, l, chronology, n, dateTimeZone, locale);
        }

        public void printTo(StringBuffer stringBuffer, ReadablePartial readablePartial, Locale locale) {
            DateTimePrinter dateTimePrinter = this.getFormatter(locale).getPrinter();
            dateTimePrinter.printTo(stringBuffer, readablePartial, locale);
        }

        public void printTo(Writer writer, ReadablePartial readablePartial, Locale locale) throws IOException {
            DateTimePrinter dateTimePrinter = this.getFormatter(locale).getPrinter();
            dateTimePrinter.printTo(writer, readablePartial, locale);
        }

        public int estimateParsedLength() {
            return 40;
        }

        public int parseInto(DateTimeParserBucket dateTimeParserBucket, String string, int n) {
            DateTimeParser dateTimeParser = this.getFormatter(dateTimeParserBucket.getLocale()).getParser();
            return dateTimeParser.parseInto(dateTimeParserBucket, string, n);
        }

        private DateTimeFormatter getFormatter(Locale locale) {
            locale = locale == null ? Locale.getDefault() : locale;
            String string = Integer.toString(this.iType + (this.iDateStyle << 4) + (this.iTimeStyle << 8)) + locale.toString();
            DateTimeFormatter dateTimeFormatter = null;
            Map map = cCache;
            synchronized (map) {
                dateTimeFormatter = (DateTimeFormatter)cCache.get(string);
                if (dateTimeFormatter == null) {
                    String string2 = this.getPattern(locale);
                    dateTimeFormatter = DateTimeFormat.forPattern(string2);
                    cCache.put(string, dateTimeFormatter);
                }
            }
            return dateTimeFormatter;
        }

        String getPattern(Locale locale) {
            DateFormat dateFormat = null;
            switch (this.iType) {
                case 0: {
                    dateFormat = DateFormat.getDateInstance(this.iDateStyle, locale);
                    break;
                }
                case 1: {
                    dateFormat = DateFormat.getTimeInstance(this.iTimeStyle, locale);
                    break;
                }
                case 2: {
                    dateFormat = DateFormat.getDateTimeInstance(this.iDateStyle, this.iTimeStyle, locale);
                }
            }
            if (!(dateFormat instanceof SimpleDateFormat)) {
                throw new IllegalArgumentException("No datetime pattern for locale: " + locale);
            }
            return ((SimpleDateFormat)dateFormat).toPattern();
        }
    }
}

