/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.crucible.spi.rpc;

import com.cenqua.fisheye.AppConfig;
import com.cenqua.fisheye.LicensePolicyException;
import com.cenqua.fisheye.rep.DbException;
import com.cenqua.fisheye.user.LoginCookie;
import com.cenqua.fisheye.user.LoginCookieToken;
import com.cenqua.fisheye.user.UserLogin;
import com.cenqua.fisheye.user.UserManager;
import com.cenqua.fisheye.web.security.UserDetector;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class RpcAuthHelper {
    @Autowired
    private HttpServletRequest request;
    @Autowired
    private HttpServletResponse response;
    @Autowired
    private UserDetector userDetector;

    public String login(String username, String password, String urlPrefix) {
        try {
            UserManager um = AppConfig.getsConfig().getUserManager();
            UserLogin user = um.login(this.request, this.response, username, password, false);
            if (user == null) {
                throw new RuntimeException("authentication failed");
            }
            LoginCookie lc = um.preCookUrl(this.request, urlPrefix, true);
            return lc.encode();
        }
        catch (DbException e2) {
            throw new RuntimeException("Internal Error", e2);
        }
        catch (LicensePolicyException e3) {
            throw new RuntimeException("Internal Error", e3);
        }
    }

    public void logout(String token) {
        UserManager um = AppConfig.getsConfig().getUserManager();
        try {
            um.logout(this.request, this.response);
        }
        catch (Exception e2) {
            throw new RuntimeException("Internal Error", e2);
        }
    }

    public UserLogin checkToken(String token) {
        try {
            UserManager um = AppConfig.getsConfig().getUserManager();
            LoginCookieToken c2 = LoginCookieToken.decode(token);
            return um.login(this.request, this.response, c2);
        }
        catch (DbException de) {
            throw new RuntimeException("Internal Error", de);
        }
    }

    public UserLogin authenticateFromRequest() {
        try {
            return this.userDetector.process(this.request, this.response);
        }
        catch (Exception e2) {
            return null;
        }
    }
}

