/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.fisheye.plugin;

import com.atlassian.plugin.DefaultPluginManager;
import com.atlassian.plugin.ModuleDescriptorFactory;
import com.atlassian.plugin.PluginParseException;
import com.atlassian.plugin.PluginStateStore;
import com.atlassian.plugin.loaders.ClassLoadingPluginLoader;
import com.atlassian.plugin.loaders.ClassPathPluginLoader;
import com.atlassian.plugin.loaders.PluginLoader;
import com.atlassian.plugin.loaders.SinglePluginLoader;
import com.cenqua.fisheye.AppConfig;
import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.springframework.context.ApplicationEvent;
import org.springframework.context.ApplicationListener;
import org.springframework.context.event.ContextRefreshedEvent;
import org.springframework.web.context.WebApplicationContext;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FisheyePluginManager
extends DefaultPluginManager
implements ApplicationListener {
    public FisheyePluginManager(PluginStateStore store, ModuleDescriptorFactory moduleDescriptorFactory, List<String> pluginLoaders) {
        super(store, FisheyePluginManager.replaceStringsWithPluginLoaders(new PluginLoader[]{new ClassLoadingPluginLoader(FisheyePluginManager.getPluginDirectory(), "atlassian-plugin.xml"), new ClassPathPluginLoader()}, pluginLoaders), moduleDescriptorFactory);
    }

    public static File getPluginDirectory() {
        File dir = new File(AppConfig.getVarDir(), "plugins");
        dir.mkdirs();
        return dir;
    }

    private static List replaceStringsWithPluginLoaders(PluginLoader[] otherLoaders, List list) {
        ArrayList<PluginLoader> finalList = new ArrayList<PluginLoader>(Arrays.asList(otherLoaders));
        for (Object o : list) {
            if (o instanceof String) {
                o = new SinglePluginLoader((String)o);
            }
            finalList.add((PluginLoader)o);
        }
        return finalList;
    }

    public void onApplicationEvent(ApplicationEvent event) {
        if (event instanceof ContextRefreshedEvent) {
            try {
                if (event.getSource() instanceof WebApplicationContext) {
                    this.init();
                }
            }
            catch (PluginParseException e2) {
                throw new RuntimeException("Error initialising plugin manager", e2);
            }
        }
    }
}

