/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.fisheye.plugin;

import com.atlassian.plugin.PluginManagerState;
import com.atlassian.plugin.PluginStateStore;
import com.cenqua.fisheye.AppConfig;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Map;
import java.util.Properties;
import org.springframework.stereotype.Component;

@Component(value="pluginStateStore")
public class PropertyFilePluginStateStore
implements PluginStateStore {
    private File propertyFile = new File(AppConfig.getVarDir(), "plugins/pluginstate.properties");

    public synchronized void savePluginState(PluginManagerState state) {
        Properties props = new Properties();
        Map map = state.getMap();
        for (Map.Entry p : map.entrySet()) {
            props.setProperty((String)p.getKey(), ((Boolean)p.getValue()).toString());
        }
        this.saveProperties(props);
    }

    public synchronized PluginManagerState loadPluginState() {
        PluginManagerState state = new PluginManagerState();
        Properties props = this.loadProperties();
        for (Map.Entry<Object, Object> p : props.entrySet()) {
            state.setState((String)p.getKey(), Boolean.valueOf(Boolean.parseBoolean((String)p.getValue())));
        }
        return state;
    }

    private Properties loadProperties() {
        Properties props = new Properties();
        if (this.propertyFile.exists()) {
            FileInputStream is = null;
            try {
                is = new FileInputStream(this.propertyFile);
                props.load(is);
            }
            catch (FileNotFoundException e2) {
                throw new RuntimeException("Couldn't find file " + this.propertyFile.getAbsolutePath(), e2);
            }
            catch (IOException e3) {
                throw new RuntimeException("Error reading file " + this.propertyFile.getAbsolutePath(), e3);
            }
            finally {
                if (is != null) {
                    try {
                        ((InputStream)is).close();
                    }
                    catch (IOException e4) {}
                }
            }
        }
        return props;
    }

    private void saveProperties(Properties props) {
        FileOutputStream os = null;
        try {
            this.propertyFile.getParentFile().mkdirs();
            os = new FileOutputStream(this.propertyFile);
            props.store(os, "List of departures from default state for plugins and plugin modules");
        }
        catch (FileNotFoundException e2) {
            throw new RuntimeException("Error creating file " + this.propertyFile.getAbsolutePath(), e2);
        }
        catch (IOException e3) {
            throw new RuntimeException("Error writing file " + this.propertyFile.getAbsolutePath(), e3);
        }
        finally {
            if (os != null) {
                try {
                    os.close();
                }
                catch (IOException e4) {}
            }
        }
    }
}

