/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.fisheye.trustedapplications;

import com.atlassian.fisheye.trustedapplications.FisheyeCurrentApplication;
import com.atlassian.fisheye.trustedapplications.FisheyeTrustedApplication;
import com.atlassian.security.auth.trustedapps.CurrentApplication;
import com.atlassian.security.auth.trustedapps.EncryptionProvider;
import com.atlassian.security.auth.trustedapps.TrustedApplication;
import com.atlassian.security.auth.trustedapps.TrustedApplicationsManager;
import com.cenqua.fisheye.AppConfig;
import com.cenqua.fisheye.config1.ConfigDocument;
import com.cenqua.fisheye.config1.CurrentApplicationType;
import com.cenqua.fisheye.config1.TrustedApplicationType;
import java.io.IOException;
import java.security.KeyPair;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import java.security.spec.InvalidKeySpecException;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Component(value="trustedApplicationsManager")
public class FisheyeTrustedApplicationsManager
implements TrustedApplicationsManager {
    private EncryptionProvider encryptionProvider;
    private FisheyeCurrentApplication cachedCurrentApplication = null;
    private Map<String, FisheyeTrustedApplication> cachedTrustedApplications = null;

    @Autowired
    public FisheyeTrustedApplicationsManager(EncryptionProvider encryptionProvider) {
        this.encryptionProvider = encryptionProvider;
    }

    public synchronized void addTrustedApplication(FisheyeTrustedApplication trustedApp) {
        this.getTrustedApplications().put(trustedApp.getID(), trustedApp);
        TrustedApplicationType app = this.getCfg().addNewTrustedApplication();
        this.createTrustedApplicationType(trustedApp, app);
        try {
            this.saveCfg();
        }
        catch (IOException e2) {
            throw new Error("Error saving trusted applications configuration", e2);
        }
    }

    public synchronized TrustedApplication getTrustedApplication(String id) {
        return (TrustedApplication)this.getTrustedApplications().get(id);
    }

    public Map<String, FisheyeTrustedApplication> getTrustedApplications() {
        if (this.cachedTrustedApplications == null) {
            this.cachedTrustedApplications = new HashMap<String, FisheyeTrustedApplication>();
            for (TrustedApplicationType ta : this.getCfg().getTrustedApplicationArray()) {
                try {
                    this.cachedTrustedApplications.put(ta.getId(), this.createTrustedApplication(ta));
                }
                catch (Exception e2) {
                    throw new Error("Error reading application " + ta.getId() + " from configuration", e2);
                }
            }
        }
        return this.cachedTrustedApplications;
    }

    private FisheyeTrustedApplication createTrustedApplication(TrustedApplicationType ta) throws NoSuchProviderException, NoSuchAlgorithmException, InvalidKeySpecException {
        return new FisheyeTrustedApplication(ta.getName(), this.encryptionProvider, this.encryptionProvider.toPublicKey(ta.getPublicKey()), ta.getId(), ta.getCertificateTimeout(), new HashSet<String>(Arrays.asList(ta.getUrlPatternArray())), new HashSet<String>(Arrays.asList(ta.getIpPatternArray())));
    }

    private void createTrustedApplicationType(FisheyeTrustedApplication app, TrustedApplicationType ta) {
        ta.setName(app.getName());
        ta.setId(app.getID());
        ta.setPublicKey(app.getPublicKey().getEncoded());
        ta.setCertificateTimeout(app.getCertificateTimeout());
        ta.setIpPatternArray(app.getIpPatterns().toArray(new String[app.getIpPatterns().size()]));
        ta.setUrlPatternArray(app.getUrlPatterns().toArray(new String[app.getUrlPatterns().size()]));
    }

    public synchronized CurrentApplication getCurrentApplication() {
        if (this.cachedCurrentApplication == null) {
            if (this.getCfg().isSetCurrentApplication()) {
                try {
                    this.cachedCurrentApplication = new FisheyeCurrentApplication(this.encryptionProvider, this.encryptionProvider.toPublicKey(this.getCfg().getCurrentApplication().getPublicKey()), this.encryptionProvider.toPrivateKey(this.getCfg().getCurrentApplication().getPrivateKey()), this.getCfg().getCurrentApplication().getId());
                }
                catch (Exception e2) {
                    throw new Error("Error reading key", e2);
                }
            }
            KeyPair keyPair = null;
            try {
                keyPair = this.encryptionProvider.generateNewKeyPair();
            }
            catch (Exception e3) {
                throw new Error("Error generating key pair", e3);
            }
            this.cachedCurrentApplication = new FisheyeCurrentApplication(this.encryptionProvider, keyPair.getPublic(), keyPair.getPrivate(), this.encryptionProvider.generateUID());
            CurrentApplicationType currentAppType = this.getCfg().addNewCurrentApplication();
            currentAppType.setId(this.cachedCurrentApplication.getID());
            currentAppType.setPublicKey(this.cachedCurrentApplication.getPublicKey().getEncoded());
            currentAppType.setPrivateKey(this.cachedCurrentApplication.getPrivateKey().getEncoded());
            try {
                this.saveCfg();
            }
            catch (IOException e4) {
                throw new Error("Error writing current application configuration", e4);
            }
        }
        return this.cachedCurrentApplication;
    }

    private ConfigDocument.Config getCfg() {
        return AppConfig.getsConfig().getConfig();
    }

    private void saveCfg() throws IOException {
        AppConfig.getsConfig().saveConfig();
    }

    public EncryptionProvider getEncryptionProvider() {
        return this.encryptionProvider;
    }

    public void updateApplication(FisheyeTrustedApplication app) {
        this.deleteApplication(app.getID());
        this.addTrustedApplication(app);
    }

    public void deleteApplication(String id) {
        this.cachedTrustedApplications.remove(id);
        TrustedApplicationType[] apps = this.getCfg().getTrustedApplicationArray();
        for (int i2 = 0; i2 < apps.length; ++i2) {
            if (!apps[i2].getId().equals(id)) continue;
            this.getCfg().removeTrustedApplication(i2);
            break;
        }
    }
}

