/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.fisheye.xwork;

import com.opensymphony.xwork.ObjectFactory;
import java.lang.reflect.Method;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationEvent;
import org.springframework.context.ApplicationListener;
import org.springframework.context.event.ContextRefreshedEvent;
import org.springframework.stereotype.Component;

@Component(value="xworkObjectFactory")
public class SpringObjectFactory
extends ObjectFactory
implements ApplicationListener {
    private ApplicationContext context;

    public Object buildBean(Class aClass) throws Exception {
        Method[] methods;
        Object bean = this.context.getAutowireCapableBeanFactory().createBean(aClass, 4, false);
        for (Method m : methods = bean.getClass().getMethods()) {
            if (!"afterPropertiesSet".equals(m.getName())) continue;
            m.invoke(bean, new Object[0]);
            break;
        }
        return bean;
    }

    public Object buildBean(String string) throws Exception {
        return this.buildBean(this.getClassInstance(string));
    }

    public void setContext(ApplicationContext context) {
        this.context = context;
    }

    public void onApplicationEvent(ApplicationEvent event) {
        if (event instanceof ContextRefreshedEvent) {
            ContextRefreshedEvent cre = (ContextRefreshedEvent)event;
            this.setContext(cre.getApplicationContext());
            ObjectFactory.setObjectFactory((ObjectFactory)this);
        }
    }
}

