/*
 * Decompiled with CFR 0.152.
 */
package com.cenqua.crucible.actions;

import com.cenqua.crucible.actions.PagedSearch;
import com.cenqua.crucible.model.managers.ReviewManager;
import com.cenqua.crucible.util.ReviewSearchTerms;
import com.cenqua.crucible.view.RowDetail;
import com.cenqua.fisheye.util.NaturalComparator;
import com.cenqua.fisheye.util.StringUtil;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SearchAction
extends PagedSearch {
    private LinkedHashMap<Integer, RowDetail> reviewDetails = null;
    private List<Integer> filteredReviews = null;

    private List<Integer> getFilteredReviewIds() {
        if (this.filteredReviews == null && !StringUtil.nullOrEmpty(this.query)) {
            this.filteredReviews = new LinkedList<Integer>();
            ReviewSearchTerms terms = new ReviewSearchTerms(this.query);
            boolean first = true;
            for (String term : terms.getAllTerms()) {
                if (first) {
                    this.filteredReviews.addAll(ReviewManager.searchReviewForTerm(term, "review.id", "review.id"));
                } else {
                    this.filteredReviews.retainAll(ReviewManager.searchReviewForTerm(term, "review.id", "review.id"));
                }
                first = false;
            }
            Collections.sort(this.filteredReviews, NaturalComparator.REVERSE_INSTANCE);
        }
        return this.filteredReviews;
    }

    public List getFilteredReviewDetails() throws Exception {
        LinkedHashMap<Integer, RowDetail> reviewDetails = this.getReviewDetailsMap();
        ArrayList<RowDetail> details = new ArrayList<RowDetail>();
        List<Integer> reviewIds = this.getFilteredReviewIds();
        if (reviewIds != null && !reviewIds.isEmpty()) {
            int end = this.getEnd();
            for (int i2 = this.getStart(); i2 < end; ++i2) {
                Integer id = reviewIds.get(i2);
                details.add(reviewDetails.get(id));
            }
        }
        return details;
    }

    @Override
    public int getNumberOfResults() {
        return this.getFilteredReviewIds() == null ? 0 : this.getFilteredReviewIds().size();
    }

    public Iterator<RowDetail> getReviewDetails() {
        return this.getReviewDetailsMap().values().iterator();
    }

    private LinkedHashMap<Integer, RowDetail> getReviewDetailsMap() {
        if (this.reviewDetails == null) {
            this.reviewDetails = ReviewManager.getReviewDetailsMap();
        }
        return this.reviewDetails;
    }
}

