/*
 * Decompiled with CFR 0.152.
 */
package com.cenqua.crucible.actions;

import com.cenqua.crucible.actions.AjaxResponse;
import com.cenqua.crucible.actions.ReviewBaseAction;
import com.cenqua.crucible.filters.CrucibleFilter;
import com.cenqua.crucible.model.FileRevision;
import com.cenqua.crucible.model.FileRevisionExtraInfo;
import com.cenqua.crucible.model.managers.FRXManager;
import com.cenqua.crucible.model.managers.FileRevisionManager;
import com.cenqua.crucible.model.managers.UserActionManager;
import com.cenqua.crucible.revision.source.RepositorySource;
import com.cenqua.crucible.revision.source.Source;
import com.cenqua.crucible.view.FRXDO;
import com.cenqua.fisheye.logging.Logs;
import com.cenqua.fisheye.rep.DbException;

public class UpdateFrxFromRevisionAction
extends ReviewBaseAction
implements AjaxResponse {
    private int frxid;
    private Integer newFromRevid;
    private FRXDO frxDO;
    private String errorMsg;
    private boolean worked = true;

    public void setFrxid(int frxid) {
        this.frxid = frxid;
    }

    public void setNewFromRevid(Integer newFromRevid) {
        this.newFromRevid = newFromRevid;
    }

    public FRXDO getFrxDO() {
        return this.frxDO;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String execute() {
        if (!this.isFileModifiable()) {
            UserActionManager userActionManager = UserActionManager.getInstance();
            this.errorMsg = userActionManager.getAction("action:modifyReviewFiles").getPermissionViolationMsg();
            this.worked = false;
            return "error";
        }
        try {
            this.beginTx();
            FileRevisionExtraInfo frx = FRXManager.getById(new Integer(this.frxid));
            if (!this.updateFrom(frx)) {
                String string = "error";
                return string;
            }
            this.frxDO = this.makeFRXDO(frx);
            this.commitTx();
            String string = "success";
            return string;
        }
        catch (Exception e2) {
            Logs.APP_LOG.error((Object)("Problem creating FRXDO from frx " + this.frxid), (Throwable)e2);
            this.errorMsg = e2.getMessage();
            this.worked = false;
            String string = "error";
            return string;
        }
        finally {
            this.rollbackTxIfNotCommited();
        }
    }

    private boolean updateFrom(FileRevisionExtraInfo frx) throws DbException {
        if (this.newFromRevid == null) {
            frx.setFromRevision(null);
        } else {
            FileRevision toRev = frx.getFileRevision();
            String sourceName = toRev.getSourceName();
            Source source = CrucibleFilter.getSource(sourceName);
            if (!(source instanceof RepositorySource)) {
                this.errorMsg = "Not Repository Source";
                this.worked = false;
                return false;
            }
            if (!source.isAvailable()) {
                this.errorMsg = source.getReason();
                this.worked = false;
                return false;
            }
            com.cenqua.fisheye.rep.FileRevision fromRev = ((RepositorySource)source).getRepoEngine().getRevisionCache().getFileRevision(this.newFromRevid);
            FileRevision cruFromRev = FileRevisionManager.createRevision(sourceName, fromRev);
            frx.setFromRevision(cruFromRev);
        }
        return true;
    }

    public String getErrorMsg() {
        return this.errorMsg;
    }

    public boolean isWorked() {
        return this.worked;
    }
}

