/*
 * Decompiled with CFR 0.152.
 */
package com.cenqua.crucible.actions;

import com.cenqua.crucible.actions.AjaxResponse;
import com.cenqua.crucible.actions.ReviewBaseAction;
import com.cenqua.crucible.model.FileRevisionExtraInfo;
import com.cenqua.crucible.model.managers.FRXManager;
import com.cenqua.crucible.view.FRXDO;
import com.cenqua.fisheye.logging.Logs;

public class ViewFRXAction
extends ReviewBaseAction
implements AjaxResponse {
    private String frxPermaId;
    private boolean showAnnotation;
    private FRXDO frxDO;
    private int u = 3;
    private boolean ignore_BL = true;
    private boolean ignore_w = false;
    private boolean ignore_b = true;
    private int frxid = -1;
    private String errorMsg = "Can't find files referenced by ";
    private boolean worked = true;

    public void setActionPathInfo(String frxPermaId) {
        this.frxPermaId = frxPermaId.substring(1);
    }

    public void setFrxid(int frxid) {
        this.frxid = frxid;
    }

    public void setShowAnnotation(boolean showAnnotation) {
        this.showAnnotation = showAnnotation;
    }

    public FRXDO getFrxDO() {
        return this.frxDO;
    }

    public boolean isShowAnnotation() {
        return this.showAnnotation;
    }

    public int getU() {
        return this.u;
    }

    public void setU(int u) {
        this.u = u;
    }

    public boolean isIgnore_BL() {
        return this.ignore_BL;
    }

    public void setIgnore_BL(boolean ignore_BL) {
        this.ignore_BL = ignore_BL;
    }

    public void setBl(boolean ignore_BL) {
        this.ignore_BL = ignore_BL;
    }

    public boolean isIgnore_w() {
        return this.ignore_w;
    }

    public void setIgnore_w(boolean ignore_w) {
        this.ignore_w = ignore_w;
    }

    public boolean isIgnore_b() {
        return this.ignore_b;
    }

    public void setIgnore_b(boolean ignore_b) {
        this.ignore_b = ignore_b;
    }

    public void setWs(String val) {
        this.ignore_b = false;
        this.ignore_w = false;
        if ("b".equals(val)) {
            this.ignore_b = true;
        } else if ("w".equals(val)) {
            this.ignore_w = true;
        }
    }

    public String getIgnore2() {
        return (this.ignore_b ? "b" : "") + (this.ignore_w ? "w" : "");
    }

    public String getErrorMsg() {
        return this.errorMsg;
    }

    public String getError() {
        return "error.general";
    }

    public String getErrorDescription() {
        return this.getErrorMsg();
    }

    public boolean isWorked() {
        return this.worked;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String execute() {
        try {
            String errorSuf;
            FileRevisionExtraInfo frx;
            this.beginTx();
            if (this.frxid != -1) {
                frx = FRXManager.getById(new Integer(this.frxid));
                errorSuf = "file revision ID " + this.frxid;
            } else {
                frx = FRXManager.getByPermaId(this.frxPermaId);
                errorSuf = "file revision PermaId " + this.frxPermaId;
            }
            if (frx == null) {
                this.errorMsg = this.errorMsg + errorSuf;
                this.worked = false;
                String string = "error";
                return string;
            }
            this.frxDO = this.makeFRXDO(frx);
            if (this.showAnnotation) {
                this.frxDO.setFromRevision(null);
            }
            this.frxDO.setDiffContext(this.u);
            this.frxDO.setIgnore_BL(this.ignore_BL);
            this.frxDO.setIgnore_b(this.ignore_b);
            this.frxDO.setIgnore_w(this.ignore_w);
            this.commitTx();
            String string = "success";
            return string;
        }
        catch (Exception e2) {
            Logs.APP_LOG.error((Object)"Problem creating FRXDO from frx", (Throwable)e2);
            this.errorMsg = "Problem creating FRXDO from frx: " + e2.getMessage();
            this.worked = false;
            String string = "error";
            return string;
        }
        finally {
            this.rollbackTxIfNotCommited();
        }
    }
}

