/*
 * Decompiled with CFR 0.152.
 */
package com.cenqua.crucible.actions.admin.permschemes;

import com.atlassian.crucible.spi.TxCallback;
import com.cenqua.crucible.actions.BaseAction;
import com.cenqua.crucible.model.PermissionScheme;
import com.cenqua.crucible.model.managers.PermissionManager;
import org.springframework.transaction.TransactionStatus;

public class CopyPermSchemeAction
extends BaseAction {
    private String name;
    private String newPSName;

    public void setName(String name) {
        this.name = name;
    }

    public String getPsName() {
        return this.newPSName;
    }

    public String execute() throws Exception {
        return this.txTemplate.execute(new TxCallback<String>(){

            @Override
            public String doInTransaction(TransactionStatus status) throws Exception {
                PermissionScheme from = PermissionManager.findPS(CopyPermSchemeAction.this.name);
                if (from == null) {
                    CopyPermSchemeAction.this.addActionError("Could not find Permission Scheme.");
                    return "error";
                }
                int i2 = 1;
                CopyPermSchemeAction.this.newPSName = from.getName() + "(copy " + i2 + ")";
                PermissionScheme newPS = PermissionManager.findPS(CopyPermSchemeAction.this.newPSName);
                while (newPS != null) {
                    CopyPermSchemeAction.this.newPSName = from.getName() + "(copy " + ++i2 + ")";
                    newPS = PermissionManager.findPS(CopyPermSchemeAction.this.newPSName);
                }
                newPS = PermissionManager.copyPermissionScheme(from, CopyPermSchemeAction.this.newPSName);
                if (newPS == null) {
                    CopyPermSchemeAction.this.addActionError("Problem creating Permission Scheme " + CopyPermSchemeAction.this.newPSName);
                    return "error";
                }
                return "success";
            }
        });
    }
}

