/*
 * Decompiled with CFR 0.152.
 */
package com.cenqua.crucible.actions.admin.permschemes;

import com.cenqua.crucible.actions.admin.permschemes.ActionData;
import com.cenqua.crucible.actions.admin.permschemes.BaseFormAction;
import com.cenqua.crucible.model.PermissionScheme;
import com.cenqua.crucible.model.managers.PermissionManager;
import com.cenqua.crucible.model.managers.UserActionManager;
import com.cenqua.crucible.model.principalAssociations.AllUserPA;
import com.cenqua.crucible.model.principalAssociations.AnonymousPA;
import com.cenqua.crucible.model.principalAssociations.GroupPA;
import com.cenqua.crucible.model.principalAssociations.RolePA;
import com.cenqua.crucible.model.principalAssociations.UserPA;

public class EditPSActionAction
extends BaseFormAction {
    private ActionData actionData;
    private String ps;
    private String action;

    public void setPsName(String name) {
        this.ps = name;
    }

    public String getPsName() {
        return this.ps;
    }

    public void setAction(String action) {
        this.action = action;
    }

    public ActionData getActionData() {
        if (this.actionData == null) {
            this.actionData = new ActionData(UserActionManager.getInstance().getAction(this.action));
            PermissionScheme pScheme = PermissionManager.findPS(this.ps);
            this.mapPsAction(pScheme, this.actionData);
        }
        return this.actionData;
    }

    private void mapPsAction(PermissionScheme ps, ActionData action) {
        for (AllUserPA allUserPA : ps.getAllUsersPAs()) {
            if (!allUserPA.getActionName().equals(action.getName())) continue;
            action.setAllUsers(true);
        }
        for (AnonymousPA anonymousPA : ps.getAnonymousPAs()) {
            if (!anonymousPA.getActionName().equals(action.getName())) continue;
            action.setAnonymousUsers(true);
        }
        for (UserPA userPA : ps.getUserPAs()) {
            if (!userPA.getActionName().equals(action.getName())) continue;
            action.addUser(userPA.getPid());
        }
        for (GroupPA groupPA : ps.getGroupPAs()) {
            if (!groupPA.getActionName().equals(action.getName())) continue;
            action.addGroup(groupPA.getPid());
        }
        for (RolePA rolePA : ps.getReviewRolePAs()) {
            if (!rolePA.getActionName().equals(action.getName())) continue;
            action.addRole(rolePA.getPid());
        }
    }
}

