/*
 * Decompiled with CFR 0.152.
 */
package com.cenqua.crucible.actions.admin.permschemes;

import com.cenqua.crucible.actions.admin.permschemes.ActionData;
import com.cenqua.crucible.actions.admin.permschemes.BaseFormAction;
import com.cenqua.crucible.model.PermissionScheme;
import com.cenqua.crucible.model.managers.PermissionManager;
import com.cenqua.crucible.model.managers.UserActionManager;
import com.cenqua.crucible.model.principalAssociations.AllUserPA;
import com.cenqua.crucible.model.principalAssociations.AnonymousPA;
import com.cenqua.crucible.model.principalAssociations.GroupPA;
import com.cenqua.crucible.model.principalAssociations.RolePA;
import com.cenqua.crucible.model.principalAssociations.UserPA;
import com.cenqua.fisheye.logging.Logs;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class EditPermSchemeAction
extends BaseFormAction {
    private String name;
    private List<ActionData> actions;

    public void setName(String name) {
        this.name = name;
    }

    public String getName() {
        return this.name;
    }

    public List<ActionData> getActions() {
        if (this.actions == null) {
            PermissionScheme ps = PermissionManager.findPS(this.name);
            if (ps == null) {
                Logs.APP_LOG.error((Object)("Permission Scheme not found: " + this.name));
            }
            this.actions = new LinkedList<ActionData>(this.mapPsActions(ps));
        }
        return this.actions;
    }

    private Collection<ActionData> mapPsActions(PermissionScheme ps) {
        ActionData ad;
        LinkedHashMap<String, ActionData> actionMap = new LinkedHashMap<String, ActionData>();
        for (UserActionManager.Action action : UserActionManager.getInstance().getActions()) {
            actionMap.put(action.getName(), new ActionData(action));
        }
        for (AllUserPA allUserPA : ps.getAllUsersPAs()) {
            ad = (ActionData)actionMap.get(allUserPA.getActionName());
            ad.setAllUsers(true);
        }
        for (AnonymousPA anonymousPA : ps.getAnonymousPAs()) {
            ad = (ActionData)actionMap.get(anonymousPA.getActionName());
            ad.setAnonymousUsers(true);
        }
        for (UserPA userPA : ps.getUserPAs()) {
            ad = (ActionData)actionMap.get(userPA.getActionName());
            ad.addUser(userPA.getPid());
        }
        for (GroupPA groupPA : ps.getGroupPAs()) {
            ad = (ActionData)actionMap.get(groupPA.getActionName());
            ad.addGroup(groupPA.getPid());
        }
        for (RolePA rolePA : ps.getReviewRolePAs()) {
            ad = (ActionData)actionMap.get(rolePA.getActionName());
            ad.addRole(rolePA.getPid());
        }
        return actionMap.values();
    }
}

