/*
 * Decompiled with CFR 0.152.
 */
package com.cenqua.crucible.actions.admin.project;

import com.atlassian.crucible.spi.TxCallback;
import com.cenqua.crucible.actions.BaseAction;
import com.cenqua.crucible.actions.admin.project.ProjectData;
import com.cenqua.crucible.actions.admin.project.ProjectDataFactory;
import com.cenqua.crucible.actions.admin.project.UserData;
import com.cenqua.crucible.model.Project;
import com.cenqua.crucible.model.managers.ProjectKeyException;
import com.cenqua.fisheye.util.StringUtil;
import java.util.HashSet;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.springframework.transaction.TransactionStatus;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class UpdateProjectAction
extends BaseAction {
    private ProjectDataFactory projectDataFactory;
    private ProjectData projectData = new ProjectData();
    private static final Pattern VALID_KEY_PROG = Pattern.compile("([A-Za-z0-9\\-]+)");

    public ProjectData getProjectData() {
        return this.projectData;
    }

    public String execute() throws Exception {
        return this.txTemplate.execute(new TxCallback<String>(){

            @Override
            public String doInTransaction(TransactionStatus status) throws Exception {
                int id = UpdateProjectAction.this.projectData.getId();
                Matcher m = VALID_KEY_PROG.matcher(UpdateProjectAction.this.projectData.getKey());
                if (!m.matches()) {
                    UpdateProjectAction.this.addActionError("Invalid project key, only alphanumeric values are allowed.");
                    return "error";
                }
                if (id < 1) {
                    Project p = UpdateProjectAction.this.projectManager.getProjectByKey(UpdateProjectAction.this.projectData.getKey());
                    if (p != null) {
                        UpdateProjectAction.this.addActionError("Could not create a new project with an existing project key.");
                        return "error";
                    }
                    p = UpdateProjectAction.this.createNewProject(UpdateProjectAction.this.projectData);
                    UpdateProjectAction.this.projectData.setId(p.getId());
                } else {
                    try {
                        UpdateProjectAction.this.projectDataFactory.updateProject(UpdateProjectAction.this.projectManager, UpdateProjectAction.this.projectData);
                    }
                    catch (ProjectKeyException e2) {
                        UpdateProjectAction.this.addActionError("Could not update project, the key is being used by another project.");
                        return "error";
                    }
                }
                return "success";
            }
        });
    }

    private Project createNewProject(ProjectData projectData) {
        Project p = this.projectManager.createProject(projectData.getName(), projectData.getKey());
        projectData.setId(p.getId());
        this.projectDataFactory.updateProject(this.projectManager, projectData);
        return p;
    }

    public void setDefaultReviewerUsers(String defaultReviewers) {
        this.projectData.setDefaultReviewerUsers(this.convertStringToUserDataSet(defaultReviewers));
    }

    public void setAllowedReviewerUsers(String allowedReviewers) {
        this.projectData.setAllowedReviewerUsers(this.convertStringToUserDataSet(allowedReviewers));
    }

    public void setDefaultReviewerGroups(String defaultReviewers) {
        this.projectData.setDefaultReviewerGroups(this.convertStringToStringSet(defaultReviewers));
    }

    public void setAllowedReviewerGroups(String allowedReviewers) {
        this.projectData.setAllowedReviewerGroups(this.convertStringToStringSet(allowedReviewers));
    }

    private Set<String> convertStringToStringSet(String names) {
        HashSet<String> s = new HashSet<String>();
        if (names != null) {
            String[] reviewerNames;
            for (String n : reviewerNames = names.split(",")) {
                s.add(n.trim());
            }
        }
        return s;
    }

    private Set<UserData> convertStringToUserDataSet(String names) {
        HashSet<UserData> s = new HashSet<UserData>();
        if (names != null) {
            String[] reviewerNames;
            for (String n : reviewerNames = names.split(",")) {
                s.add(new UserData(n.trim(), ""));
            }
        }
        return s;
    }

    public void setDefaultModerator(String defaultModerator) {
        if (!StringUtil.nullOrEmpty(defaultModerator)) {
            this.projectData.setDefaultModerator(new UserData(defaultModerator, ""));
        }
    }

    public void setProjectDataFactory(ProjectDataFactory projectDataFactory) {
        this.projectDataFactory = projectDataFactory;
    }
}

