/*
 * Decompiled with CFR 0.152.
 */
package com.cenqua.crucible.actions.create;

import com.cenqua.crucible.actions.AjaxResponse;
import com.cenqua.crucible.actions.ReviewBaseAction;
import com.cenqua.crucible.actions.create.RepoNameSelectHelper;
import com.cenqua.crucible.model.CrucibleUser;
import com.cenqua.crucible.model.Project;
import com.cenqua.crucible.model.managers.CrucibleUserManager;
import com.cenqua.crucible.model.managers.LogManager;
import com.cenqua.crucible.model.managers.UserActionManager;
import com.cenqua.crucible.notification.NotificationManager;
import com.cenqua.fisheye.rep.DbException;
import java.util.Arrays;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Set;

public class EditReviewDetailsAction
extends ReviewBaseAction
implements AjaxResponse {
    private String title;
    private Project project;
    private String description;
    private String author;
    private String moderator;
    private boolean allowJoin;
    private Set<String> selectedReviewers = new HashSet<String>();
    private String repoName;
    private String command;
    private String errorMsg = "";
    private boolean worked = true;

    public boolean isWorked() {
        return this.worked;
    }

    public String getErrorMsg() {
        return this.errorMsg;
    }

    private void log(String message) {
        LogManager.log(this.getCurrentUser().getDisplayName() + " altering " + this.getReview().getPermaId() + message);
    }

    public String getTitle() {
        return this.getReview().getName();
    }

    public void setTitle(String title) {
        this.title = title;
    }

    public void setProjectId(int projectId) {
        this.project = this.projectManager.getProjectById(projectId);
    }

    public Project getProject() {
        return this.project;
    }

    public String getDescription() {
        return this.getReview().getDescription();
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public CrucibleUser getIterationAuthor() {
        return this.getReview().getAuthor();
    }

    public void setNewAuthor(String author) {
        this.author = author;
    }

    public CrucibleUser getIterationModerator() {
        return this.getReview().getModerator();
    }

    public void setNewModerator(String moderator) {
        this.moderator = moderator;
    }

    public void setReviewers(String[] vals) {
        this.selectedReviewers.addAll(Arrays.asList(vals));
    }

    public boolean isAllowJoin() {
        return this.getReview().isAllowReviewerToJoin();
    }

    public void setAllowJoin(boolean allowJoin) {
        this.allowJoin = allowJoin;
    }

    public Set getSelectedReviewers() throws DbException {
        List<CrucibleUser> users = this.getUsers();
        LinkedHashMap<CrucibleUser, Boolean> reviewers = new LinkedHashMap<CrucibleUser, Boolean>();
        Set<CrucibleUser> ar = this.getReview().getReviewers();
        for (CrucibleUser user : users) {
            reviewers.put(user, ar.contains(user));
        }
        return reviewers.entrySet();
    }

    public String getRepoName() {
        return RepoNameSelectHelper.convertNullToSentinel(this.getReview().getRepoName());
    }

    public void setRepoName(String repoName) {
        this.repoName = RepoNameSelectHelper.convertSentinelToNull(repoName);
    }

    public boolean isUsingRepo() {
        return this.repoName != null;
    }

    public String getCommand() {
        return this.command;
    }

    public void setCommand(String command) {
        this.command = command;
    }

    private boolean changed(String newVal, String currentVal) {
        return newVal != null && (currentVal == null || !newVal.equals(currentVal));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String execute() throws Exception {
        if (!this.isFileModifiable()) {
            UserActionManager userActionManager = UserActionManager.getInstance();
            this.errorMsg = userActionManager.getAction("action:modifyReviewFiles").getPermissionViolationMsg();
            this.worked = false;
            return "ajaxError";
        }
        try {
            this.beginTx();
            if (this.command == null) {
                this.commitTx();
                String userActionManager = "success";
                return userActionManager;
            }
            if (this.changed(this.title, this.getReview().getName())) {
                this.log(" changing title to \"" + this.title + "\"");
                this.getReview().setName(this.title);
            }
            if (this.changed(this.description, this.getReview().getDescription())) {
                this.log(" changing description to \"" + this.description + "\"");
                this.getReview().setDescription(this.description);
            }
            if (this.getReview().isAllowReviewerToJoin() != this.allowJoin) {
                this.log(" changing allow reviewers to join to \"" + this.allowJoin + "\"");
                this.getReview().setAllowReviewerToJoin(this.allowJoin);
            }
            if (this.author != null) {
                CrucibleUser newAuthor = CrucibleUserManager.getUserByName(this.author);
                if (!this.getReview().isAuthor(newAuthor)) {
                    if (this.getReview().getState().isReviewState()) {
                        NotificationManager.INSTANCE.noteGeneralMsg(this.getReview(), this.getCurrentUser(), newAuthor, "You have been assigned author of review " + this.getPermaId());
                        NotificationManager.INSTANCE.noteGeneralMsg(this.getReview(), this.getCurrentUser(), this.getReview().getAuthor(), "You have been replaced as author of review " + this.getPermaId() + " by " + newAuthor.getDisplayName());
                    }
                    this.log(" changing author to " + this.author);
                    this.getReview().setAuthor(newAuthor);
                }
            }
            if (this.moderator != null) {
                CrucibleUser newModerator = CrucibleUserManager.getUserByName(this.moderator);
                if (!this.getReview().isModerator(newModerator)) {
                    if (this.getReview().getState().isReviewState()) {
                        NotificationManager.INSTANCE.noteGeneralMsg(this.getReview(), this.getCurrentUser(), newModerator, "You have been made moderator of review " + this.getPermaId());
                        NotificationManager.INSTANCE.noteGeneralMsg(this.getReview(), this.getCurrentUser(), this.getReview().getModerator(), "You have been replaced as moderator of review " + this.getPermaId() + " by " + newModerator.getDisplayName());
                    }
                    this.log(" changing moderator to " + this.moderator);
                    this.getReview().setModerator(newModerator);
                }
            }
            if (this.changed(this.repoName, this.getReview().getRepoName())) {
                this.log(" changing repository to \"" + this.repoName + "\"");
                this.getReview().setRepoName(this.repoName);
            }
            HashSet<CrucibleUser> reviewers = new HashSet<CrucibleUser>();
            reviewers.addAll(this.getReview().getReviewers());
            for (CrucibleUser user : reviewers) {
                if (this.selectedReviewers.contains(user.getUserName())) continue;
                this.getReview().removeReviewer(user);
                this.log(" removing reviewer " + user.getUserName());
                if (!this.getReview().getState().isReviewState()) continue;
                NotificationManager.INSTANCE.noteGeneralMsg(this.getReview(), this.getCurrentUser(), user, "You have been removed as a reviewer in review " + this.getPermaId());
            }
            for (String reviewer : this.selectedReviewers) {
                CrucibleUser user = CrucibleUserManager.getUserByName(reviewer);
                if (reviewers.contains(user)) continue;
                this.getReview().addReviewer(user);
                this.log(" adding reviewer " + reviewer);
                if (!this.getReview().getState().isReviewState()) continue;
                NotificationManager.INSTANCE.noteGeneralMsg(this.getReview(), this.getCurrentUser(), user, "You have been added as a reviewer in review " + this.getPermaId());
            }
            if (this.project != null && !this.project.equals(this.getReview().getProject())) {
                try {
                    this.getReview().changeProject(this.project);
                }
                catch (DbException e2) {
                    this.errorMsg = "Problem getting Reviewers: " + e2.getMessage();
                    this.worked = false;
                    String string = "ajaxError";
                    this.rollbackTxIfNotCommited();
                    return string;
                }
            }
            this.commitTx();
            String string = this.command;
            return string;
        }
        finally {
            this.rollbackTxIfNotCommited();
        }
    }
}

