/*
 * Decompiled with CFR 0.152.
 */
package com.cenqua.crucible.actions.create;

import com.cenqua.crucible.actions.AjaxResponse;
import com.cenqua.crucible.actions.ReviewBaseAction;
import com.cenqua.crucible.filters.CrucibleFilter;
import com.cenqua.crucible.model.FileRevision;
import com.cenqua.crucible.model.FileRevisionExtraInfo;
import com.cenqua.crucible.model.managers.FileRevisionManager;
import com.cenqua.crucible.model.managers.UserActionManager;
import com.cenqua.crucible.revision.source.RepositorySource;
import com.cenqua.crucible.revision.source.Source;
import com.cenqua.crucible.revision.source.SourceException;
import com.cenqua.crucible.util.PatchReviewCreationHelper;
import com.cenqua.crucible.util.ReviewCreationHelper;
import com.cenqua.fisheye.logging.Logs;
import com.cenqua.fisheye.util.StringUtil;
import java.util.ArrayList;
import java.util.List;
import org.hibernate.exception.GenericJDBCException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class EditRevisionsAjaxAction
extends ReviewBaseAction
implements AjaxResponse {
    private ReviewCreationHelper createHelper;
    private String command;
    private String sourceName;
    private String diff;
    private int[] revids;
    private String errorMsg = "";
    private boolean worked = true;
    private List<FileRevisionExtraInfo> addedItems;
    private List<FileRevision> removedItems;
    private List<String> messages;

    private ReviewCreationHelper getCreateHelper() throws SourceException {
        Source s;
        if (this.createHelper == null && (s = CrucibleFilter.getSource(this.sourceName)) instanceof RepositorySource) {
            this.createHelper = new ReviewCreationHelper((RepositorySource)s, this.getReview());
        }
        return this.createHelper;
    }

    private void setErrorMessage(String msg) {
        this.errorMsg = msg;
        this.worked = false;
    }

    @Override
    public String getErrorMsg() {
        return this.errorMsg;
    }

    @Override
    public boolean isWorked() {
        return this.worked;
    }

    public void setCommand(String command) {
        this.command = command;
    }

    public void setRevid(int[] revid) {
        this.revids = revid;
    }

    public void setSourceName(String sourceName) {
        this.sourceName = sourceName;
    }

    public void setDiff(String diff) {
        this.diff = diff;
    }

    public List<FileRevisionExtraInfo> getAddedItems() {
        return this.addedItems;
    }

    public List<FileRevision> getRemovedItems() {
        return this.removedItems;
    }

    public List<String> getMessages() {
        return this.messages;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String execute() throws Exception {
        if (!this.isFileModifiable()) {
            UserActionManager userActionManager = UserActionManager.getInstance();
            this.setErrorMessage(userActionManager.getAction("action:modifyReviewFiles").getPermissionViolationMsg());
            return "error";
        }
        try {
            ReviewCreationHelper ch;
            this.beginTx();
            if (this.command == null) {
                this.setErrorMessage("No revision was added or removed.");
                this.commitTx();
                String userActionManager = "error";
                return userActionManager;
            }
            if (StringUtil.nullOrEmpty(this.sourceName)) {
                Logs.APP_LOG.info((Object)"no repository specified in request");
                this.setErrorMessage("No revision was added or removed.");
                this.commitTx();
                String userActionManager = "error";
                return userActionManager;
            }
            if (this.revids == null) {
                this.revids = new int[0];
            }
            if ((ch = this.getCreateHelper()) == null) {
                this.addRemovePatchRev();
                Logs.APP_LOG.info((Object)"Not a Repository Source");
            } else {
                this.addRemoveRepoRev(ch);
            }
            this.commitTx();
            String string = "success";
            return string;
        }
        catch (SourceException e2) {
            this.setErrorMessage("No revision was added or removed. " + e2.getMessage());
            String string = "error";
            return string;
        }
        catch (GenericJDBCException e3) {
            this.setErrorMessage("No revision was added or removed. " + e3.getMessage());
            String string = "error";
            return string;
        }
        finally {
            this.rollbackTxIfNotCommited();
        }
    }

    private void addRemoveRepoRev(ReviewCreationHelper ch) throws Exception {
        if (this.command.equals("add")) {
            ch.addRevisions(this.getCurrentUser(), this.revids, "lastrev".equals(this.diff));
        } else if (this.command.equals("remove")) {
            ch.removeRevisions(this.getCurrentUser(), this.revids);
        } else if (this.command.equals("removeAll")) {
            ch.removeAllRevisions(this.getCurrentUser());
        } else {
            Logs.APP_LOG.debug((Object)("unknown command '" + this.command + "'"));
        }
        this.addedItems = ch.getAddedItems();
        this.removedItems = ch.getRemovedItems();
        this.messages = ch.getMessages();
    }

    private void addRemovePatchRev() {
        boolean add = this.command.equals("add");
        this.addedItems = new ArrayList<FileRevisionExtraInfo>();
        this.removedItems = new ArrayList<FileRevision>();
        this.messages = new ArrayList<String>();
        for (int revId : this.revids) {
            if (add) {
                FileRevisionExtraInfo frx = PatchReviewCreationHelper.getFRXForRevFromPatch(revId, this.getReview());
                if (frx == null) {
                    Logs.APP_LOG.warn((Object)("can't find file revision with id " + revId + "to add"));
                    this.messages.add("can't find file revision with id " + revId);
                    return;
                }
                this.addedItems.add(frx);
                continue;
            }
            FileRevision fr = FileRevisionManager.getById(revId);
            if (fr == null) {
                Logs.APP_LOG.warn((Object)("can't find file revision with id " + revId + "to remove"));
                this.messages.add("can't find file revision with id " + revId);
                return;
            }
            this.removedItems.add(fr);
            this.getReview().removeFileRevision(fr);
        }
    }
}

