/*
 * Decompiled with CFR 0.152.
 */
package com.cenqua.crucible.actions.create;

import com.cenqua.crucible.actions.create.EditRevisionsAction;
import com.cenqua.crucible.filters.CrucibleFilter;
import com.cenqua.crucible.revision.source.RepositorySource;
import com.cenqua.fisheye.Path;
import com.cenqua.fisheye.cache.RevisionCache;
import com.cenqua.fisheye.cvsrep.search.SearchManager;
import com.cenqua.fisheye.cvsrep.search.SearchResults;
import com.cenqua.fisheye.cvsrep.search.SimpleSearchParameters;
import com.cenqua.fisheye.cvsrep.search.query.FishQuery;
import com.cenqua.fisheye.logging.Logs;
import com.cenqua.fisheye.rep.DbException;
import com.cenqua.fisheye.web.SearchResultsExplorer;
import com.cenqua.fisheye.web.UrlHelper;
import java.util.ArrayList;
import javax.servlet.http.HttpServletRequest;
import org.apache.lucene.analysis.Analyzer;

public class EditSearchAction
extends EditRevisionsAction {
    public String getEditMode() {
        return "search";
    }

    protected String doView() {
        String result = super.doView();
        if (result.equals("successRedirect")) {
            return result;
        }
        HttpServletRequest req = CrucibleFilter.getRequest();
        if (!this.isRepositoryAvailable()) {
            return result;
        }
        Path lpath = this.getPathInfo().getLocalPath();
        RevisionCache rep = ((RepositorySource)this.getSource()).getRepoEngine().getRevisionCache();
        req.setAttribute("repname", (Object)this.getSource().getSourceIdentifier());
        try {
            if (rep.isFile(lpath)) {
                lpath = lpath.getParent();
            }
            if (!rep.isDir(lpath)) {
                lpath = new Path();
            }
            this.doSearch(lpath, req);
        }
        catch (Exception e2) {
            this.addActionError(e2.getMessage());
        }
        return result;
    }

    private void doSearch(Path path, HttpServletRequest req) throws DbException {
        FishQuery query;
        ArrayList<String> errors = new ArrayList<String>(1);
        req.setAttribute("errors", errors);
        if (!this.isRepositoryAvailable()) {
            Logs.APP_LOG.warn((Object)("error doing search: Repository not available. " + this.getSource().getReason()));
            errors.add("Repository not available");
            errors.add(this.getSource().getReason());
            return;
        }
        Path searchPath = path;
        String searchAllDirsStr = req.getParameter("searchAllDirs");
        if (searchAllDirsStr != null && "true".equals(searchAllDirsStr)) {
            searchPath = new Path();
        }
        String ql = req.getParameter("ql");
        UrlHelper searchUrl = new UrlHelper();
        searchUrl.setUrl(req.getContextPath() + "/cru/" + this.getReview().getPermaId() + "/edit-search/" + this.getSource().getSourceIdentifier() + "/" + path.getPath());
        if (ql != null) {
            req.setAttribute("qlStr", (Object)ql);
            req.setAttribute("isAdvanced", (Object)"true");
            searchUrl.getParams().put("ql", ql);
            query = ql.trim().length() > 0 ? FishQuery.parse(ql, errors) : null;
        } else {
            SimpleSearchParameters params = new SimpleSearchParameters(req, (Analyzer)((RepositorySource)this.getSource()).getRepositoryHandle().getCfg().getMasterAnalyzer());
            query = params.parseUserData(searchPath, searchUrl);
            if (query != null) {
                req.setAttribute("qlStr", (Object)query.makeQueryString());
            }
        }
        if (query != null) {
            if (query.getFromPath() == null) {
                query.setFromPath(searchPath);
            }
            try {
                SearchManager searcher = ((RepositorySource)this.getSource()).getRepoEngine().getSearchManager();
                boolean refresh = req.getParameter("refresh") != null;
                SearchResults collator = searcher.runQuery(query, refresh);
                SearchResultsExplorer results = new SearchResultsExplorer(collator);
                results.init(req, searchUrl);
                req.setAttribute("results", (Object)results);
            }
            catch (Exception e2) {
                Logs.APP_LOG.warn((Object)"error doing search", (Throwable)e2);
                errors.add("General search term error:" + e2.getMessage());
            }
        }
        req.setAttribute("path", (Object)path);
        req.setAttribute("fpath", (Object)new Path(new Path(this.getSource().getSourceIdentifier()), path.getPath()));
        req.setAttribute("authors", ((RepositorySource)this.getSource()).getRepoEngine().getRevisionCache().findAuthors(path));
    }
}

