/*
 * Decompiled with CFR 0.152.
 */
package com.cenqua.crucible.configuration.metrics;

import com.cenqua.crucible.configuration.metrics.MetricsConfig;
import com.cenqua.crucible.configuration.metrics.MetricsConfigDef;
import com.cenqua.crucible.configuration.metrics.XMLValidationException;
import com.cenqua.crucible.hibernate.HibernateUtil;
import com.cenqua.fisheye.AppConfig;
import com.cenqua.fisheye.io.IOHelper;
import com.cenqua.fisheye.logging.Logs;
import com.cenqua.fisheye.util.VariableSubstituter;
import java.io.File;
import java.io.Serializable;
import java.util.HashMap;
import java.util.List;
import java.util.Properties;
import org.hibernate.Session;

public class MetricsManager {
    public static final MetricsManager INSTANCE = new MetricsManager();
    private HashMap configCache = new HashMap();

    public Integer storeNewConfig(File file, boolean force) throws Exception {
        return this.storeNewConfig(IOHelper.copyFileToString(file), force);
    }

    private String getParsedXML(String xml) throws XMLValidationException {
        MetricsConfig mc = new MetricsConfig();
        if (mc.parseXml(xml)) {
            return mc.getXML();
        }
        throw new XMLValidationException(mc.getErrors());
    }

    public Integer storeNewConfig(String xml, boolean force) throws XMLValidationException {
        Integer version = new Integer(-1);
        String parsedXML = this.getParsedXML(xml);
        if (force || !this.sameAsLatest(parsedXML)) {
            MetricsConfigDef def = new MetricsConfigDef();
            HibernateUtil.currentSession().save((Object)def);
            version = def.getVersion();
            def.setXml(parsedXML);
        }
        return version;
    }

    public Integer replaceConfig(File file, Integer version) throws Exception {
        String xml = this.getParsedXML(IOHelper.copyFileToString(file));
        MetricsConfigDef def = this.getConfigDef(version);
        if (def == null) {
            Logs.APP_LOG.warn((Object)"Existing version not found. Metrics not replaced.");
            return null;
        }
        def.setXml(xml);
        return version;
    }

    public MetricsConfigDef getConfigDef(Integer version) {
        if (version != null) {
            return (MetricsConfigDef)HibernateUtil.currentSession().load(MetricsConfigDef.class, (Serializable)version);
        }
        return null;
    }

    public MetricsConfig getConfig(Integer version) {
        if (version != null) {
            if (!this.configCache.containsKey(version)) {
                this.configCache.put(version, new MetricsConfig(this.getConfigDef(version).getXml(), version));
            }
            return (MetricsConfig)this.configCache.get(version);
        }
        return null;
    }

    public List getConfigs() {
        return HibernateUtil.currentSession().createQuery("from MetricsConfigDef").list();
    }

    public Integer getLatestVersion() {
        Session session = HibernateUtil.currentSession();
        Integer version = (Integer)session.createQuery("select max(id) from MetricsConfigDef").uniqueResult();
        if (version != null) {
            return version;
        }
        Properties feprops = new Properties();
        feprops.setProperty("fisheye.home", AppConfig.getAppHome().getAbsolutePath());
        String defaultMetrics = VariableSubstituter.substituteRefs((CharSequence)"${fisheye.home}/default-metrics-config.xml", feprops);
        File defaultMetricsXML = new File(defaultMetrics);
        if (defaultMetricsXML.exists()) {
            try {
                return this.storeNewConfig(defaultMetricsXML, true);
            }
            catch (Exception e2) {
                Logs.APP_LOG.warn((Object)"DefaultMetrics exists but there is a problem so I can't install it.", (Throwable)e2);
            }
        }
        return null;
    }

    private boolean sameAsLatest(String xml) {
        return this.getConfigDef(this.getLatestVersion()).getXml().equals(xml);
    }
}

