/*
 * Decompiled with CFR 0.152.
 */
package com.cenqua.crucible.filters;

import com.cenqua.crucible.CrucibleVersionInfo;
import com.cenqua.crucible.hibernate.HibernateUtil;
import com.cenqua.crucible.model.CrucibleUser;
import com.cenqua.crucible.model.Principal;
import com.cenqua.crucible.model.managers.CrucibleUserManager;
import com.cenqua.crucible.model.managers.ProjectManager;
import com.cenqua.crucible.revision.source.Source;
import com.cenqua.crucible.revision.source.SourceFactory;
import com.cenqua.fisheye.AppConfig;
import com.cenqua.fisheye.config.SpringContext;
import com.cenqua.fisheye.user.UserLogin;
import com.cenqua.fisheye.user.UserManager;
import com.cenqua.fisheye.util.Disposer;
import java.io.IOException;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CrucibleFilter
implements Filter {
    private static final ThreadLocal<Context> CONTEXT = new ThreadLocal();

    private static Context getContext() {
        Context ctx = CONTEXT.get();
        if (ctx == null) {
            throw new IllegalStateException("Context not available, filter already exited");
        }
        return ctx;
    }

    public static boolean hasContext() {
        return CONTEXT.get() != null;
    }

    public static HttpServletRequest getRequest() {
        return CrucibleFilter.getContext().request;
    }

    public static HttpServletResponse getResponse() {
        return CrucibleFilter.getContext().response;
    }

    public static CrucibleUser getCurrentUser() {
        return CrucibleFilter.getContext().user;
    }

    public static Principal getCurrentPrincipal() {
        Principal p = CrucibleFilter.getContext().login;
        if (p == null) {
            p = Principal.Anonymous.ANON;
        }
        return p;
    }

    public static List<String> getAllProjectCodes() {
        return CrucibleFilter.getContext().getAllProjectCodes();
    }

    public static String getSiteURL() {
        return CrucibleFilter.getBaseUrl(CrucibleFilter.getRequest());
    }

    public static Source getSource(String sourceName) {
        return CrucibleFilter.getContext().getSource(sourceName);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void doFilter(ServletRequest servletRequest, ServletResponse servletResponse, FilterChain filterChain) throws IOException, ServletException {
        Disposer.pushThreadInstance();
        try {
            Context oldContext = CONTEXT.get();
            try {
                UserLogin login = this.getCurrentLogin(servletRequest);
                CrucibleUser crucibleUser = this.getCurrentUser(login);
                CONTEXT.set(new Context(servletRequest, servletResponse, login, crucibleUser));
                filterChain.doFilter(servletRequest, servletResponse);
            }
            finally {
                Context currentContext = CONTEXT.get();
                if (currentContext != null && oldContext == null) {
                    HibernateUtil.closeSession();
                }
                CONTEXT.set(oldContext);
            }
        }
        finally {
            Disposer.popThreadInstance();
        }
    }

    public void init(FilterConfig filterConfig) throws ServletException {
        ServletContext sc = filterConfig.getServletContext();
        sc.setAttribute("CRUCIBLE_VERSION_INFO", (Object)new CrucibleVersionInfo());
    }

    public void destroy() {
    }

    private CrucibleUser getCurrentUser(UserLogin login) {
        if (login == null) {
            return null;
        }
        return CrucibleUserManager.getUserByName(login.getUsername());
    }

    private UserLogin getCurrentLogin(ServletRequest request) {
        UserManager um = AppConfig.getsConfig().getUserManager();
        UserLogin login = um.getCurrentUser((HttpServletRequest)request);
        return login;
    }

    private static String getBaseUrl(HttpServletRequest req) {
        String ctx;
        StringBuffer url = new StringBuffer(48);
        String scheme = req.getScheme();
        url.append(scheme);
        url.append("://");
        url.append(req.getServerName());
        int port = req.getServerPort();
        if (port > 0 && (scheme.equalsIgnoreCase("http") && port != 80 || scheme.equalsIgnoreCase("https") && port != 443)) {
            url.append(':');
            url.append(port);
        }
        if (!(ctx = req.getContextPath()).startsWith("/")) {
            url.append("/");
        }
        url.append(ctx);
        char lastc = url.charAt(url.length() - 1);
        if (lastc != '/') {
            url.append("/");
        }
        return url.toString();
    }

    public static void setContext(Context c2) {
        CONTEXT.set(c2);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class Context {
        public final HttpServletRequest request;
        public final HttpServletResponse response;
        public final CrucibleUser user;
        public final UserLogin login;
        private final Map<String, Source> sources = new HashMap<String, Source>();
        private List<String> projectCodes;

        public Context(ServletRequest req, ServletResponse resp, UserLogin login, CrucibleUser user) {
            this.request = (HttpServletRequest)req;
            this.response = (HttpServletResponse)resp;
            this.user = user;
            this.login = login;
        }

        public Source getSource(String sourceName) {
            if (!this.sources.containsKey(sourceName)) {
                this.sources.put(sourceName, SourceFactory.getSource(sourceName, this.request));
            }
            return this.sources.get(sourceName);
        }

        public List<String> getAllProjectCodes() {
            if (this.projectCodes == null) {
                ProjectManager projectManager = (ProjectManager)SpringContext.getComponent("projectManager");
                this.projectCodes = projectManager.getAllProjectKeys();
            }
            return this.projectCodes;
        }
    }
}

