/*
 * Decompiled with CFR 0.152.
 */
package com.cenqua.crucible.helpers;

import com.cenqua.crucible.hibernate.Config;
import java.io.FileWriter;
import org.hibernate.cfg.Configuration;
import org.hibernate.dialect.Dialect;

public class CreateDB {
    private Configuration setup() throws Exception {
        return Config.configDB();
    }

    private void saveSchema(String fileName, Configuration cfg) throws Exception {
        String s;
        int i2;
        Class<?> dialectClass = Class.forName(cfg.getProperty("hibernate.dialect"));
        Dialect dialect = (Dialect)dialectClass.newInstance();
        String[] script = cfg.generateSchemaCreationScript(dialect);
        FileWriter outFile = new FileWriter(fileName);
        for (i2 = 0; i2 < script.length; ++i2) {
            s = script[i2];
            outFile.write(s + ";\n");
        }
        outFile.close();
        script = cfg.generateDropSchemaScript(dialect);
        outFile = new FileWriter("drop-" + fileName);
        for (i2 = 0; i2 < script.length; ++i2) {
            s = script[i2];
            outFile.write(s + ";\n");
        }
        outFile.close();
    }

    public void execute(String fileName) throws Exception {
        this.saveSchema(fileName, this.setup());
    }

    public static void main(String[] args) {
        CreateDB cdbs = new CreateDB();
        if (args.length != 1) {
            System.out.println("Usage: CreateDBSchema FileName");
            System.exit(-1);
        }
        try {
            cdbs.execute(args[0]);
            System.out.println("Created DB schema, see: " + args[0]);
        }
        catch (Exception e2) {
            System.err.println("Create failed, sorry. Reason: " + e2.getMessage());
            e2.printStackTrace();
            System.exit(-1);
        }
    }
}

