/*
 * Decompiled with CFR 0.152.
 */
package com.cenqua.crucible.helpers;

import com.cenqua.crucible.configuration.metrics.MetricsManager;
import com.cenqua.crucible.hibernate.HibernateUtil;
import java.io.File;
import org.hibernate.Transaction;

public class ManageMetricsConfig {
    private static void printUsage() {
        System.err.println("Usage: ManageMetricsConfig command [path/filename]\nCommands:\nnew - add a new config from a file\ncurrent - print out the current config xml file to stdout\nreplace - replace a current config from a file (use with care!)\nget - get a particular version of config\nExamples:\nManageMetricsConfig new fully/qualified/path/to/metrics_config.xml\nManageMetricsConfig replace fully/qualified/path/to/metrics_config.xml versionNo\nManageMetricsConfig get 2 > my_copy_of_config_v2.xml\nManageMetricsConfig current > my_copy_of_config.xml\n");
    }

    private static void doNew(String fileName) throws Exception {
        HibernateUtil.setUp();
        Transaction tx = HibernateUtil.currentSession().beginTransaction();
        System.out.println("Saved " + fileName + " as version " + MetricsManager.INSTANCE.storeNewConfig(new File(fileName), false));
        tx.commit();
        HibernateUtil.closeSession();
    }

    private static void doReplace(String fileName, Integer ver) throws Exception {
        HibernateUtil.setUp();
        Transaction tx = HibernateUtil.currentSession().beginTransaction();
        Integer version = MetricsManager.INSTANCE.replaceConfig(new File(fileName), ver);
        if (version != null) {
            System.out.println("Replaced config " + fileName + " as version " + version);
        } else {
            System.out.println("Failed to replace config " + fileName);
        }
        tx.commit();
        HibernateUtil.closeSession();
    }

    private static void doCurrent() throws Exception {
        HibernateUtil.setUp();
        Transaction tx = HibernateUtil.currentSession().beginTransaction();
        System.out.println(MetricsManager.INSTANCE.getConfigDef(MetricsManager.INSTANCE.getLatestVersion()).getXml());
        tx.commit();
        HibernateUtil.closeSession();
    }

    private static void doGetVersion(int version) throws Exception {
        HibernateUtil.setUp();
        Transaction tx = HibernateUtil.currentSession().beginTransaction();
        System.out.println(MetricsManager.INSTANCE.getConfigDef(new Integer(version)).getXml());
        tx.commit();
        HibernateUtil.closeSession();
    }

    public static void main(String[] args) {
        if (args.length < 1) {
            ManageMetricsConfig.printUsage();
        }
        try {
            if (args[0].equalsIgnoreCase("new")) {
                if (args.length != 2) {
                    ManageMetricsConfig.printUsage();
                    System.exit(-1);
                }
                ManageMetricsConfig.doNew(args[1]);
            }
            if (args[0].equalsIgnoreCase("current")) {
                ManageMetricsConfig.doCurrent();
            }
            if (args[0].equalsIgnoreCase("replace")) {
                if (args.length != 3) {
                    ManageMetricsConfig.printUsage();
                    System.exit(-1);
                }
                ManageMetricsConfig.doReplace(args[1], new Integer(args[2]));
            }
            if (args[0].equalsIgnoreCase("get")) {
                if (args.length != 2) {
                    ManageMetricsConfig.printUsage();
                    System.exit(-1);
                }
                ManageMetricsConfig.doGetVersion(Integer.parseInt(args[1]));
            }
        }
        catch (Exception e2) {
            System.err.println(e2.getMessage());
        }
    }
}

